/*
 * Decompiled with CFR 0.152.
 */
package pnuts.nio;

import java.io.IOException;
import java.nio.CharBuffer;
import pnuts.text.AbstractLineReader;
import pnuts.text.LineHandler;

class CharBufferLineReader
extends AbstractLineReader {
    protected CharBuffer cbuf;
    protected LineHandler handler;
    static final int defaultBufferSize = 8192;

    public CharBufferLineReader(CharBuffer cbuf, int sz) {
        super(sz);
        this.cbuf = cbuf;
    }

    public CharBufferLineReader(CharBuffer cbuf) {
        this(cbuf, 8192);
    }

    protected CharBufferLineReader() {
    }

    protected int fill(char[] c, int offset, int size2) throws IOException {
        int rem = this.cbuf.remaining();
        if (rem <= 0) {
            return -1;
        }
        if (size2 > rem) {
            size2 = rem;
        }
        this.cbuf.get(c, offset, size2);
        return size2;
    }

    public void setLineHandler(LineHandler handler) {
        this.handler = handler;
    }

    public LineHandler getLineHandler() {
        return this.handler;
    }

    protected void process(char[] c, int offset, int length) {
        this.handler.process(c, offset, length);
    }
}

