/*
 * Decompiled with CFR 0.152.
 */
package pnuts.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.lang.Runtime;
import pnuts.servlet.DynamicPage;
import pnuts.servlet.PnutsServlet;
import pnuts.servlet.protocol.pea.Handler;

public class DynamicPageServlet
extends PnutsServlet {
    private String workdir;

    public void init() throws ServletException {
        ServletConfig conf = this.getServletConfig();
        String workdir = conf.getInitParameter("workdir");
        if (workdir != null) {
            this.workdir = workdir;
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pnuts parseFile(File file, String encoding, Context context) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        Reader reader2 = encoding != null ? new InputStreamReader((InputStream)fin, encoding) : Runtime.getScriptReader((InputStream)fin, (Context)context);
        StringWriter sw = new StringWriter();
        try {
            DynamicPage.convert(reader2, sw, null, null, context);
        }
        finally {
            reader2.close();
        }
        URL url = new URL(null, "pea:" + file.toURL(), new Handler(context));
        return Pnuts.parse((Reader)new StringReader(sw.toString()), (Object)url, (Context)context);
    }

    void do_service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.workdir == null) {
            super.do_service(request, response);
            return;
        }
        try {
            File outputFile;
            String s_path = request.getServletPath();
            String path = "";
            if (s_path != null) {
                path = s_path;
            }
            if (path == null) {
                path = request.getPathInfo();
            }
            String real_path = this.getServletContext().getRealPath(path);
            File file = null;
            if (real_path != null) {
                file = new File(real_path);
            }
            if (file == null || !file.exists()) {
                if (this.debug) {
                    throw new FileNotFoundException(real_path);
                }
                response.sendError(404);
                return;
            }
            String filename = file.getName();
            if (filename.endsWith(".pnut")) {
                response.sendError(500, "");
                return;
            }
            int idx = filename.lastIndexOf(46);
            String s = idx > 0 ? filename.substring(0, idx) + ".pnut" : filename + ".pnut";
            File dir = file.getParentFile();
            if (this.workdir != null && !(dir = new File(dir, this.workdir)).exists()) {
                dir.mkdirs();
            }
            if (!(outputFile = new File(dir, s)).exists() || outputFile.lastModified() < file.lastModified()) {
                DynamicPage.convert(file, outputFile, this.encoding, new Context());
            }
            request.getRequestDispatcher(s).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable e) {
            if (this.debug) {
                e.printStackTrace();
            } else {
                System.err.println(e);
            }
            response.sendError(500, "");
        }
    }
}

