/*
 * Decompiled with CFR 0.152.
 */
package pnuts.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import pnuts.compiler.Compiler;
import pnuts.compiler.CompilerPnutsImpl;
import pnuts.lang.Context;
import pnuts.lang.Implementation;
import pnuts.lang.Package;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsImpl;
import pnuts.lang.Runtime;
import pnuts.servlet.PnutsServletContext;
import pnuts.servlet.ResponseWriter;

public class PnutsServlet
extends HttpServlet {
    public static final String SYMBOL_THIS = "this".intern();
    public static final String SYMBOL_REQUEST = "request".intern();
    public static final String SYMBOL_RESPONSE = "response".intern();
    public static final String SERVLET_REQUEST = "request".intern();
    public static final String SERVLET_RESPONSE = "response".intern();
    public static final String SERVLET_BUFFER = "pnuts.servlet.buffer".intern();
    public static final String SERVLET_WRITER = "pnuts.servlet.writer".intern();
    public static final String SERVLET_MULTIPART_PARAM = "pnuts.servlet.multipart.param".intern();
    public static final String SERVLET_PARAM = "pnuts.servlet.parameters".intern();
    public static final String SERVLET_COOKIE = "pnuts.servlet.cookies".intern();
    public static final String SERVLET_FILE = "pnuts.servlet.file".intern();
    public static final String REQUEST_SCOPE = "pnuts.servlet.request.scope".intern();
    public static final String SERVLET_COMPILER = "pnuts.servlet.compiler".intern();
    private static final String LOCALE_KEY = "pnuts$lib$locale".intern();
    private static final String TIMEZONE_KEY = "pnuts$lib$timezone".intern();
    boolean debug;
    boolean buffering;
    boolean compile = true;
    Compiler compiler;
    String encoding;
    boolean isolation;
    private Hashtable contexts = new Hashtable();
    private Context context = new Context();
    private Package pkg;

    public void init() throws ServletException {
        StringTokenizer st;
        String _isolation;
        ServletConfig conf = this.getServletConfig();
        this.debug = Boolean.valueOf(conf.getInitParameter("debug"));
        String module = conf.getInitParameter("module");
        String _compile = conf.getInitParameter("compile");
        this.compile = Boolean.valueOf(_compile);
        boolean compile2 = this.compile;
        if (compile2) {
            this.compiler = new Compiler(null, false, true);
            this.context.set(SERVLET_COMPILER, (Object)this.compiler);
        }
        String locale2 = conf.getInitParameter("locale");
        String timezone = conf.getInitParameter("timezone");
        Object pnutsImpl = compile2 ? new CompilerPnutsImpl(true, true) : PnutsImpl.getDefault();
        this.context.setImplementation((Implementation)pnutsImpl);
        String _buffering = conf.getInitParameter("buffering");
        this.buffering = _buffering != null ? Boolean.valueOf(_buffering) : true;
        this.encoding = conf.getInitParameter("encoding");
        if (this.encoding != null) {
            this.context.setScriptEncoding(this.encoding);
        }
        this.isolation = (_isolation = conf.getInitParameter("isolation")) != null ? Boolean.valueOf(_isolation) : true;
        if (locale2 != null) {
            Locale loc;
            st = new StringTokenizer(locale2, "_");
            int n = st.countTokens();
            switch (n) {
                case 0: {
                    loc = new Locale("");
                    break;
                }
                case 1: {
                    loc = new Locale(st.nextToken(), "", "");
                    break;
                }
                case 2: {
                    loc = new Locale(st.nextToken(), st.nextToken(), "");
                    break;
                }
                default: {
                    loc = new Locale(st.nextToken(), st.nextToken(), st.nextToken());
                }
            }
            this.context.set(LOCALE_KEY, (Object)loc);
        }
        if (timezone != null) {
            this.context.set(TIMEZONE_KEY, (Object)TimeZone.getTimeZone(timezone));
        }
        this.pkg = new Package("root", null);
        this.context.setCurrentPackage(this.pkg);
        if (module != null) {
            st = new StringTokenizer(module, ",", false);
            while (st.hasMoreTokens()) {
                String mod = st.nextToken().trim();
                this.context.usePackage(mod);
            }
        }
        String name = conf.getInitParameter("initialScript");
        try {
            if (name != null) {
                Pnuts.require((String)name, (Context)this.context);
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.do_service(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.do_service(request, response);
    }

    protected ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void do_service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Context c = null;
        Package p = null;
        Pnuts script = null;
        long time = 0L;
        try {
            String s_path = request.getServletPath();
            String path = "";
            if (s_path != null) {
                path = s_path;
            }
            if (path == null) {
                path = request.getPathInfo();
            }
            String real_path = this.getServletContext().getRealPath(path);
            File file = null;
            if (real_path != null) {
                file = new File(real_path);
            }
            if (file == null || !file.exists()) {
                if (this.debug) {
                    throw new FileNotFoundException(real_path);
                }
                response.sendError(404);
                return;
            }
            Hashtable hashtable = this.contexts;
            synchronized (hashtable) {
                PnutsServletContext ctx = (PnutsServletContext)this.contexts.get(file);
                if (ctx == null) {
                    ClassLoader ccl = this.getContextClassLoader();
                    URL[] urls = new URL[]{file.getParentFile().toURL()};
                    URLClassLoader loader = new URLClassLoader(urls, ccl);
                    c = this.isolation ? new Context(this.context) : (Context)this.context.clone();
                    c.setClassLoader((ClassLoader)loader);
                    c.set(SERVLET_FILE, (Object)file);
                    c.set(SYMBOL_THIS, (Object)this);
                    p = this.isolation ? (Package)this.pkg.clone() : this.pkg;
                    ctx = new PnutsServletContext(c, p);
                    this.contexts.put(file, ctx);
                    if (this.debug) {
                        c.setVerbose(true);
                    }
                } else {
                    c = ctx.context;
                    p = ctx.basePackage;
                    script = ctx.script;
                    time = ctx.time;
                }
            }
            c = (Context)c.clone();
            Thread.currentThread().setContextClassLoader(c.getClassLoader());
            boolean buffering = this.buffering;
            ResponseWriter rw = new ResponseWriter((ServletResponse)response, c, buffering);
            c.setWriter((Writer)rw);
            p.set(SYMBOL_THIS, (Object)this, c);
            Package pkg = new Package(null, p);
            pkg.set(SYMBOL_RESPONSE, (Object)response, c);
            pkg.set(SYMBOL_REQUEST, (Object)request, c);
            c.set(SERVLET_RESPONSE, (Object)response);
            c.set(SERVLET_REQUEST, (Object)request);
            c.set(REQUEST_SCOPE, (Object)pkg);
            c.setCurrentPackage(pkg);
            if (script == null) {
                ctx.script = script = this.readScript(file, this.encoding, c);
                ctx.time = System.currentTimeMillis();
            } else {
                long lastModified = file.lastModified();
                if (time < lastModified) {
                    ctx.script = script = this.readScript(file, this.encoding, c);
                    ctx.time = System.currentTimeMillis();
                }
            }
            script.run(c);
            if (buffering) {
                rw.flushBuffer();
            }
        }
        catch (Throwable e) {
            if (this.debug) {
                e.printStackTrace();
            } else {
                System.err.println(e);
            }
            response.sendError(500, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pnuts parseFile(File file, String encoding, Context context) throws IOException {
        URL scriptURL = file.toURL();
        Reader reader2 = null;
        reader2 = encoding != null ? new InputStreamReader((InputStream)new FileInputStream(file), encoding) : Runtime.getScriptReader((InputStream)new FileInputStream(file), (Context)context);
        try {
            Pnuts pnuts = Pnuts.parse((Reader)reader2, (Object)scriptURL, (Context)context);
            return pnuts;
        }
        finally {
            if (reader2 != null) {
                reader2.close();
            }
        }
    }

    protected Pnuts readScript(File file, String encoding, Context context) throws IOException {
        Pnuts expr;
        block4: {
            if (this.debug) {
                System.out.println("readScript " + file);
            }
            expr = this.parseFile(file, encoding, context);
            if (this.compile) {
                try {
                    expr = this.compiler.compile(expr, context);
                }
                catch (ClassFormatError e) {
                    if (!this.debug) break block4;
                    System.out.println("compile failed (interpreting)");
                }
            }
        }
        return expr;
    }

    public String getServletInfo() {
        return "Pnuts Servlet for servlet scripting. See http://pnuts.org/ for more information";
    }
}

