/*
 * Decompiled with CFR 0.152.
 */
package pnuts.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class URLEncoding {
    private static final boolean DEBUG = false;
    private static BitSet dontNeedEncoding;
    private static final int caseDiff = 32;

    protected URLEncoding() {
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer();
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)buf, enc);
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                if (c == 32) {
                    c = 43;
                }
                out.append((char)c);
                continue;
            }
            try {
                writer2.write(c);
                writer2.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
        }
        return out.toString();
    }

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    bout.write(32);
                    continue block6;
                }
                case '%': {
                    try {
                        bout.write(Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(s.substring(i + 1, i + 3));
                    }
                    i += 2;
                    continue block6;
                }
                default: {
                    bout.write(c);
                }
            }
        }
        return new String(bout.toByteArray(), enc);
    }

    public static Map parseQueryString(String s, String enc) throws UnsupportedEncodingException {
        String[] valArray = null;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) continue;
            String key = URLEncoding.decode(pair.substring(0, pos), enc);
            String val = URLEncoding.decode(pair.substring(pos + 1, pair.length()), enc);
            if (ht.containsKey(key)) {
                String[] oldVals = (String[])ht.get(key);
                valArray = new String[oldVals.length + 1];
                for (int i = 0; i < oldVals.length; ++i) {
                    valArray[i] = oldVals[i];
                }
                valArray[oldVals.length] = val;
            } else {
                valArray = new String[]{val};
            }
            ht.put(key, valArray);
        }
        return ht;
    }

    public static String makeQueryString(Map table, String enc) throws UnsupportedEncodingException {
        boolean first = true;
        StringBuffer buf = new StringBuffer();
        Iterator it = table.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = table.get(key);
            if (value instanceof Object[]) {
                Object[] avalue = (Object[])value;
                for (int i = 0; i < avalue.length; ++i) {
                    String svalue = String.valueOf(avalue[i]);
                    if (svalue == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        buf.append("&");
                    }
                    if (value == null) continue;
                    buf.append(URLEncoding.encode(key, enc) + "=" + URLEncoding.encode(svalue, enc));
                }
                continue;
            }
            if (!(value instanceof String)) continue;
            String svalue = (String)value;
            if (first) {
                first = false;
            } else {
                buf.append("&");
            }
            if (value == null) continue;
            buf.append(URLEncoding.encode(key, enc) + "=" + URLEncoding.encode(svalue, enc));
        }
        return buf.toString();
    }

    static {
        int i;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

