/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.commons.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;

public class Grid {
    public static Point snap(Point p, int spacing) {
        if (spacing <= 0) {
            return null;
        }
        return new Point((p.x + spacing / 2) / spacing * spacing, (p.y + spacing / 2) / spacing * spacing);
    }

    public static void draw(Component c, Graphics g, Dimension spacing) {
        int i;
        if (spacing == null) {
            return;
        }
        Shape clip = g.getClip();
        Rectangle r = c.getBounds();
        g.setColor(Color.lightGray);
        g.clipRect(0, 0, r.width, r.height);
        for (i = 0; i < r.height; i += spacing.height) {
            g.drawLine(0, i, r.width, i);
        }
        for (i = 0; i < r.width; i += spacing.width) {
            g.drawLine(i, 0, i, r.height);
        }
        g.setClip(clip);
    }

    public static void draw(Component c, Graphics g, int spacing) {
        int i;
        if (spacing <= 0) {
            return;
        }
        Shape clip = g.getClip();
        Rectangle r = c.getBounds();
        g.setColor(Color.lightGray);
        g.clipRect(0, 0, r.width, r.height);
        for (i = 0; i < r.height; i += spacing) {
            g.drawLine(0, i, r.width, i);
        }
        for (i = 0; i < r.width; i += spacing) {
            g.drawLine(i, 0, i, r.height);
        }
        g.setClip(clip);
    }

    public static void draw(Rectangle r, Graphics g, Dimension spacing) {
        int i;
        if (spacing == null) {
            return;
        }
        g.setColor(Color.lightGray);
        for (i = r.y; i <= r.y + r.height; i += spacing.height) {
            g.drawLine(r.x, i, r.x + r.width, i);
        }
        for (i = r.x; i <= r.x + r.width; i += spacing.width) {
            g.drawLine(i, r.y, i, r.y + r.height);
        }
    }

    public static void draw(Rectangle r, Graphics g, int spacing) {
        int i;
        if (spacing <= 0) {
            return;
        }
        g.setColor(Color.lightGray);
        for (i = r.y; i <= r.y + r.height; i += spacing) {
            g.drawLine(r.x, i, r.x + r.width, i);
        }
        for (i = r.x; i <= r.x + r.width; i += spacing) {
            g.drawLine(i, r.y, i, r.y + r.height);
        }
    }
}

