/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.commons.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.swing.JPanel;

public class VersionPanel
extends JPanel {
    private Image logo;
    private String copyright = "";
    private String version = "";
    private Color color = Color.black;

    public VersionPanel(String path, String version, String copyright, Color color) {
        this.version = version != null ? version : "";
        this.copyright = copyright != null ? copyright : "";
        this.color = color != null ? color : Color.black;
        try {
            this.logo = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(path));
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.logo, 0);
            tracker.waitForID(0);
            Dimension size = new Dimension(this.logo.getWidth(this), this.logo.getHeight(this));
            this.setPreferredSize(size);
        }
        catch (Exception ex) {
            this.logo = null;
            this.setPreferredSize(new Dimension(350, 250));
        }
    }

    public void paintComponent(Graphics g) {
        int dy;
        int dx;
        int width;
        if (this.logo != null) {
            g.drawImage(this.logo, 0, 0, this);
        }
        Dimension size = this.getSize();
        Font f = new Font("SansSerif", 1, 12);
        FontMetrics metrics = g.getFontMetrics(f);
        int height = metrics.getHeight();
        int descent = metrics.getDescent();
        g.setColor(this.color);
        g.setFont(f);
        if (this.version != null) {
            width = metrics.stringWidth(this.version);
            dx = (size.width - width) / 2;
            dy = size.height - (height + descent + 20);
            g.drawString(this.version, dx, dy);
        }
        if (this.copyright != null) {
            width = metrics.stringWidth(this.copyright);
            dx = (size.width - width) / 2;
            dy = size.height - (descent + 10);
            g.drawString(this.copyright, dx, dy);
        }
    }
}

