/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.Document;
import jp.co.argo21.commons.swing.BooleanDocument;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.expression.ExceptionExpression;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;
import jp.co.argo21.nautica.tool.wfd.expression.LogicalExpression;
import jp.co.argo21.nautica.tool.wfd.expression.OtherwiseExpression;
import jp.co.argo21.nautica.tool.wfd.expression.RelationalExpression;
import jp.co.argo21.nautica.tool.wfd.expression.UnaryExpression;

public class ConditionEditorView
extends JTabbedPane {
    public static String[] STR_OPS;
    public static String[] NUM_OPS;
    public static String[] BOOL_OPS;
    public static String[] LOG_OPS;
    private static String varTableColumn;
    private static String condTableColumn;
    protected static final Border border;
    private JRadioButton condButton;
    private JRadioButton otherButton;
    private JRadioButton exButton;
    private JTable varTable;
    private JComboBox basOpeBox;
    private JTextField basRField;
    private JTextField unaryField;
    private JTextField logLField;
    private JComboBox logOpeBox;
    private JTextField logRField;
    private JRadioButton basButton;
    private JRadioButton unaryButton;
    private JRadioButton logButton;
    private JTable condTable;
    private JButton selUniButton;
    private JButton selLogLButton;
    private JButton selLogRButton;
    private JButton addButton;
    private JTextArea previewArea;
    private Expression expression;
    private List vars;
    private List expressions = new ArrayList();
    private Expression logLExp;
    private Expression logRExp;
    private Expression unaryExp;
    private Document strDocument = new ByteLimitedDocument(128);
    private Document numDocument = new NumericDocument(9, true);
    private Document boolDocument = new BooleanDocument();
    static /* synthetic */ Class class$jp$co$argo21$nautica$tool$wfd$element$Element;
    static /* synthetic */ Class class$jp$co$argo21$nautica$tool$wfd$expression$Expression;

    public ConditionEditorView() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel = this.createConditionEditorPanel(rm);
        this.addTab(rm.getResource("ConditionEditorView.tab.0"), panel);
        this.validate();
    }

    private JPanel createConditionEditorPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(580, 370);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("ConditionEditorView.label.0"));
        this.condButton = new JRadioButton(rm.getResource("ConditionEditorView.kind.0"));
        this.condButton.addActionListener(new SelectConditionAction());
        this.otherButton = new JRadioButton(rm.getResource("ConditionEditorView.kind.1"));
        this.otherButton.addActionListener(new SelectOtherwiseAction());
        this.exButton = new JRadioButton(rm.getResource("ConditionEditorView.kind.2"));
        this.exButton.addActionListener(new SelectExceptionAction());
        JPanel kindPane = new JPanel();
        kindPane.setLayout(new GridLayout(1, 3, 5, 5));
        kindPane.setBorder(border);
        kindPane.add(this.condButton);
        kindPane.add(this.otherButton);
        kindPane.add(this.exButton);
        ButtonGroup kindGroup = new ButtonGroup();
        kindGroup.add(this.condButton);
        kindGroup.add(this.otherButton);
        kindGroup.add(this.exButton);
        this.basButton = new JRadioButton(rm.getResource("ConditionEditorView.cond.0"));
        this.basButton.addActionListener(new SelectBasicExpressionAction());
        this.unaryButton = new JRadioButton(rm.getResource("ConditionEditorView.cond.1"));
        this.unaryButton.addActionListener(new SelectUnaryExpressionAction());
        this.logButton = new JRadioButton(rm.getResource("ConditionEditorView.cond.2"));
        this.logButton.addActionListener(new SelectLogicalExpressionAction());
        ButtonGroup expGroup = new ButtonGroup();
        expGroup.add(this.basButton);
        expGroup.add(this.unaryButton);
        expGroup.add(this.logButton);
        this.varTable = new JTable(new VarTableModel());
        this.varTable.setSelectionMode(0);
        this.varTable.setRowHeight(35);
        this.varTable.getColumnModel().getColumn(0).setCellRenderer(new VarRenderer());
        ListSelectionModel vlsm = this.varTable.getSelectionModel();
        vlsm.addListSelectionListener(new VarSelectAction());
        JScrollPane sp0 = new JScrollPane();
        sp0.setViewportView(this.varTable);
        this.basOpeBox = new JComboBox<String>(STR_OPS);
        this.basRField = new JTextField();
        this.basRField.setDocument(this.strDocument);
        this.unaryField = new JTextField();
        this.unaryField.setEditable(false);
        this.logLField = new JTextField();
        this.logLField.setEditable(false);
        this.logOpeBox = new JComboBox<String>(LOG_OPS);
        this.logRField = new JTextField();
        this.logRField.setEditable(false);
        this.selUniButton = new JButton(rm.getResource("JButton.label.select"));
        this.selUniButton.addActionListener(new SelectExpressionAction(this.unaryField));
        this.selLogLButton = new JButton(rm.getResource("JButton.label.select"));
        this.selLogLButton.addActionListener(new SelectExpressionAction(this.logLField));
        this.selLogRButton = new JButton(rm.getResource("JButton.label.select"));
        this.selLogRButton.addActionListener(new SelectExpressionAction(this.logRField));
        this.condTable = new JTable(new ConditionTableModel());
        this.condTable.setSelectionMode(0);
        this.condTable.setRowHeight(35);
        this.condTable.getColumnModel().getColumn(0).setCellRenderer(new ConditionRenderer());
        ListSelectionModel clsm = this.condTable.getSelectionModel();
        clsm.addListSelectionListener(new ConditionSelectAction());
        JScrollPane sp1 = new JScrollPane();
        sp1.setViewportView(this.condTable);
        this.addButton = new JButton(rm.getResource("JButton.label.add"));
        this.addButton.addActionListener(new AddExpressionAction());
        this.previewArea = new JTextArea();
        this.previewArea.setLineWrap(true);
        this.previewArea.setEditable(false);
        JScrollPane sp2 = new JScrollPane();
        sp2.setViewportView(this.previewArea);
        this.condButton.setSelected(true);
        this.basButton.setSelected(true);
        this.setConditionEditable(true);
        this.setBasicExpressionEditable();
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(kindPane, 10, 40, 560, 35));
        panel.add(this.locate(this.basButton, 10, 80, 105, 25));
        panel.add(this.locate(this.unaryButton, 10, 190, 105, 25));
        panel.add(this.locate(this.logButton, 10, 220, 105, 25));
        panel.add(this.locate(sp0, 120, 80, 165, 105));
        panel.add(this.locate(this.basOpeBox, 290, 130, 100, 25));
        panel.add(this.locate(this.basRField, 290, 160, 100, 25));
        panel.add(this.locate(this.unaryField, 120, 190, 100, 25));
        panel.add(this.locate(this.selUniButton, 225, 190, 60, 25));
        panel.add(this.locate(this.logOpeBox, 290, 220, 100, 25));
        panel.add(this.locate(this.logLField, 120, 220, 100, 25));
        panel.add(this.locate(this.selLogLButton, 225, 220, 60, 25));
        panel.add(this.locate(this.logRField, 120, 250, 100, 25));
        panel.add(this.locate(this.selLogRButton, 225, 250, 60, 25));
        panel.add(this.locate(sp1, 400, 80, 170, 225));
        panel.add(this.locate(this.addButton, 330, 280, 60, 25));
        panel.add(this.locate(sp2, 10, 310, 560, 50));
        this.validate();
        return panel;
    }

    private void setConditionEditable(boolean b) {
        this.basButton.setEnabled(b);
        this.unaryButton.setEnabled(b);
        this.logButton.setEnabled(b);
        this.varTable.setEnabled(b);
        this.basOpeBox.setEnabled(b);
        this.basRField.setEditable(b);
        this.selUniButton.setEnabled(b);
        this.logOpeBox.setEnabled(b);
        this.selLogLButton.setEnabled(b);
        this.selLogRButton.setEnabled(b);
        this.addButton.setEnabled(b);
    }

    private void setBasicExpressionEditable() {
        this.varTable.setEnabled(true);
        this.basOpeBox.setEnabled(true);
        this.basRField.setEditable(true);
        this.selUniButton.setEnabled(false);
        this.logOpeBox.setEnabled(false);
        this.selLogLButton.setEnabled(false);
        this.selLogRButton.setEnabled(false);
        this.addButton.setEnabled(true);
        this.varTable.clearSelection();
        this.basOpeBox.setSelectedIndex(0);
        this.basRField.setText("");
        this.basRField.setToolTipText("");
    }

    private void setUnaryExpressionEditable() {
        this.varTable.setEnabled(false);
        this.basOpeBox.setEnabled(false);
        this.basRField.setEditable(false);
        this.selUniButton.setEnabled(true);
        this.logOpeBox.setEnabled(false);
        this.selLogLButton.setEnabled(false);
        this.selLogRButton.setEnabled(false);
        this.addButton.setEnabled(true);
        this.unaryField.setText("");
        this.unaryField.setToolTipText("");
        this.unaryExp = null;
    }

    private void setLogicalExpressionEditable() {
        this.varTable.setEnabled(false);
        this.basOpeBox.setEnabled(false);
        this.basRField.setEditable(false);
        this.selUniButton.setEnabled(false);
        this.logOpeBox.setEnabled(true);
        this.selLogLButton.setEnabled(true);
        this.selLogRButton.setEnabled(true);
        this.addButton.setEnabled(true);
        this.logLField.setText("");
        this.logLField.setToolTipText("");
        this.logOpeBox.setSelectedIndex(0);
        this.logRField.setText("");
        this.logRField.setToolTipText("");
        this.logLExp = null;
        this.logRExp = null;
    }

    private void variableSelected(VariableElement var) {
        int type = var.getType();
        if (type == 3) {
            this.basOpeBox.setModel(new DefaultComboBoxModel<String>(NUM_OPS));
            this.basRField.setHorizontalAlignment(4);
        } else if (type == 6) {
            this.basOpeBox.setModel(new DefaultComboBoxModel<String>(BOOL_OPS));
            this.basRField.setHorizontalAlignment(2);
        } else {
            this.basOpeBox.setModel(new DefaultComboBoxModel<String>(STR_OPS));
            this.basRField.setHorizontalAlignment(2);
        }
        this.basOpeBox.updateUI();
    }

    private void makeNewBasicExpression() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        int selected = this.varTable.getSelectedRow();
        if (selected < 0) {
            DialogUtilities.showError(rm.getResource("message.error.0041"));
            return;
        }
        int ope = 1;
        if (this.basOpeBox.getSelectedIndex() == 1) {
            ope = 2;
        } else if (this.basOpeBox.getSelectedIndex() == 2) {
            ope = 3;
        } else if (this.basOpeBox.getSelectedIndex() == 3) {
            ope = 4;
        } else if (this.basOpeBox.getSelectedIndex() == 4) {
            ope = 5;
        } else if (this.basOpeBox.getSelectedIndex() == 5) {
            ope = 6;
        }
        VariableElement v = (VariableElement)this.vars.get(selected);
        RelationalExpression exp = new RelationalExpression(v.getID(), ope, this.basRField.getText());
        this.expressions.add(exp);
        this.setBasicExpressionEditable();
        this.condTable.updateUI();
    }

    private void makeNewUnaryExpression() {
        if (this.unaryExp == null) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            DialogUtilities.showError(rm.getResource("message.error.0042"));
            return;
        }
        UnaryExpression exp = new UnaryExpression(this.unaryExp);
        this.expressions.add(exp);
        this.setUnaryExpressionEditable();
        this.condTable.updateUI();
    }

    private void makeNewLogicalExpression() {
        if (this.logLExp == null) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            DialogUtilities.showError(rm.getResource("message.error.0043"));
            return;
        }
        if (this.logRExp == null) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            DialogUtilities.showError(rm.getResource("message.error.0044"));
            return;
        }
        int ope = 1;
        if (this.logOpeBox.getSelectedIndex() == 0) {
            ope = 2;
        }
        LogicalExpression exp = new LogicalExpression(this.logLExp, ope, this.logRExp);
        this.expressions.add(exp);
        this.setLogicalExpressionEditable();
        this.condTable.updateUI();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression exp) {
        this.expression = exp;
        int ix = -1;
        if (exp == null) {
            this.setConditionEditable(true);
            this.condButton.setSelected(true);
        } else if (exp instanceof OtherwiseExpression) {
            this.setConditionEditable(false);
            this.otherButton.setSelected(true);
        } else if (exp instanceof ExceptionExpression) {
            this.setConditionEditable(false);
            this.exButton.setSelected(true);
        } else {
            this.setConditionEditable(true);
            this.condButton.setSelected(true);
            exp.getAllExpressions(this.expressions);
            ix = this.expressions.indexOf(exp);
        }
        this.repaint();
        if (ix > -1) {
            this.condTable.getSelectionModel().setLeadSelectionIndex(ix);
        }
    }

    public boolean check() {
        if (this.condButton.isSelected()) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            int selected = this.condTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("message.warn.0005"));
                return false;
            }
        }
        return true;
    }

    public void commit() {
        if (this.condButton.isSelected()) {
            int selected = this.condTable.getSelectedRow();
            this.expression = (Expression)this.expressions.get(selected);
        } else if (this.otherButton.isSelected()) {
            this.expression = new OtherwiseExpression();
        } else if (this.exButton.isSelected()) {
            this.expression = new ExceptionExpression();
        }
    }

    protected Component locate(Component component, int x, int y, int w, int h) {
        component.setLocation(x, y);
        component.setSize(w, h);
        return component;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        STR_OPS = new String[2];
        ConditionEditorView.STR_OPS[0] = rm.getResource("ConditionEditorView.basicope.0");
        ConditionEditorView.STR_OPS[1] = rm.getResource("ConditionEditorView.basicope.1");
        NUM_OPS = new String[6];
        ConditionEditorView.NUM_OPS[0] = rm.getResource("ConditionEditorView.basicope.0");
        ConditionEditorView.NUM_OPS[1] = rm.getResource("ConditionEditorView.basicope.1");
        ConditionEditorView.NUM_OPS[2] = rm.getResource("ConditionEditorView.basicope.2");
        ConditionEditorView.NUM_OPS[3] = rm.getResource("ConditionEditorView.basicope.3");
        ConditionEditorView.NUM_OPS[4] = rm.getResource("ConditionEditorView.basicope.4");
        ConditionEditorView.NUM_OPS[5] = rm.getResource("ConditionEditorView.basicope.5");
        BOOL_OPS = new String[2];
        ConditionEditorView.BOOL_OPS[0] = rm.getResource("ConditionEditorView.basicope.0");
        ConditionEditorView.BOOL_OPS[1] = rm.getResource("ConditionEditorView.basicope.1");
        LOG_OPS = new String[2];
        ConditionEditorView.LOG_OPS[0] = rm.getResource("ConditionEditorView.logope.0");
        ConditionEditorView.LOG_OPS[1] = rm.getResource("ConditionEditorView.logope.1");
        varTableColumn = rm.getResource("ConditionEditorView.column.0");
        condTableColumn = rm.getResource("ConditionEditorView.column.1");
    }

    class ConditionRenderer
    extends DefaultTableCellRenderer {
        private Icon icon;

        ConditionRenderer() {
            String name = "condition-cur";
            this.icon = IconManager.getIcon(name);
        }

        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            Expression exp = (Expression)o;
            String s = exp.getExpressionString(ConditionEditorView.this.vars);
            this.setText(s);
            if (this.icon != null) {
                this.setIcon(this.icon);
            }
            this.setToolTipText(s);
            return this;
        }
    }

    class ConditionTableModel
    extends AbstractTableModel {
        ConditionTableModel() {
            ConditionEditorView.this.vars = WorkflowDesignerManager.getMainFrame().getPackage().getVariables();
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return ConditionEditorView.this.expressions.size();
        }

        public String getColumnName(int col) {
            return condTableColumn;
        }

        public Object getValueAt(int row, int col) {
            return ConditionEditorView.this.expressions.get(row);
        }

        public Class getColumnClass(int col) {
            return class$jp$co$argo21$nautica$tool$wfd$expression$Expression == null ? (class$jp$co$argo21$nautica$tool$wfd$expression$Expression = ConditionEditorView.class$("jp.co.argo21.nautica.tool.wfd.expression.Expression")) : class$jp$co$argo21$nautica$tool$wfd$expression$Expression;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class VarRenderer
    extends DefaultTableCellRenderer {
        private Icon icon;

        VarRenderer() {
            String name = "variable-cur";
            this.icon = IconManager.getIcon(name);
        }

        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            Element elem = (Element)o;
            this.setText(elem.getName());
            if (this.icon != null) {
                this.setIcon(this.icon);
            }
            this.setToolTipText(elem.getTooltipText(rm));
            return this;
        }
    }

    class VarTableModel
    extends AbstractTableModel {
        VarTableModel() {
            ConditionEditorView.this.vars = WorkflowDesignerManager.getMainFrame().getPackage().getVariables();
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return ConditionEditorView.this.vars.size();
        }

        public String getColumnName(int col) {
            return varTableColumn;
        }

        public Object getValueAt(int row, int col) {
            return ConditionEditorView.this.vars.get(row);
        }

        public Class getColumnClass(int col) {
            return class$jp$co$argo21$nautica$tool$wfd$element$Element == null ? (class$jp$co$argo21$nautica$tool$wfd$element$Element = ConditionEditorView.class$("jp.co.argo21.nautica.tool.wfd.element.Element")) : class$jp$co$argo21$nautica$tool$wfd$element$Element;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class ConditionSelectAction
    implements ListSelectionListener {
        ConditionSelectAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selected = lsm.getMinSelectionIndex();
                ConditionEditorView.this.previewArea.setText(((Expression)ConditionEditorView.this.expressions.get(selected)).getExpressionString(ConditionEditorView.this.vars));
            }
        }
    }

    class VarSelectAction
    implements ListSelectionListener {
        VarSelectAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selected = lsm.getMinSelectionIndex();
                VariableElement v = (VariableElement)ConditionEditorView.this.vars.get(selected);
                ConditionEditorView.this.variableSelected(v);
                int type = v.getType();
                String s = v.getInitialValue();
                if (s == null) {
                    s = "";
                }
                ConditionEditorView.this.basRField.setText(s);
                if (type == 3) {
                    ConditionEditorView.this.basRField.setDocument(ConditionEditorView.this.numDocument);
                    ConditionEditorView.this.basRField.setHorizontalAlignment(4);
                } else if (type == 6) {
                    ConditionEditorView.this.basRField.setDocument(ConditionEditorView.this.boolDocument);
                    ConditionEditorView.this.basRField.setHorizontalAlignment(2);
                } else {
                    ConditionEditorView.this.basRField.setDocument(ConditionEditorView.this.strDocument);
                    ConditionEditorView.this.basRField.setHorizontalAlignment(2);
                }
            }
        }
    }

    class SelectExpressionAction
    extends AbstractAction {
        private JTextField field;

        SelectExpressionAction(JTextField f) {
            this.field = f;
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            int selected = ConditionEditorView.this.condTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("message.warn.0005"));
                return;
            }
            Expression exp = (Expression)ConditionEditorView.this.expressions.get(selected);
            if (this.field == ConditionEditorView.this.unaryField) {
                ConditionEditorView.this.unaryExp = exp;
            } else if (this.field == ConditionEditorView.this.logLField) {
                ConditionEditorView.this.logLExp = exp;
            } else if (this.field == ConditionEditorView.this.logRField) {
                ConditionEditorView.this.logRExp = exp;
            }
            this.field.setText(exp.getExpressionString(ConditionEditorView.this.vars));
            this.field.setToolTipText(exp.getExpressionString(ConditionEditorView.this.vars));
        }
    }

    class AddExpressionAction
    extends AbstractAction {
        AddExpressionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ConditionEditorView.this.basButton.isSelected()) {
                ConditionEditorView.this.makeNewBasicExpression();
            } else if (ConditionEditorView.this.unaryButton.isSelected()) {
                ConditionEditorView.this.makeNewUnaryExpression();
            } else if (ConditionEditorView.this.logButton.isSelected()) {
                ConditionEditorView.this.makeNewLogicalExpression();
            }
        }
    }

    class SelectUnaryExpressionAction
    extends AbstractAction {
        SelectUnaryExpressionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ConditionEditorView.this.setUnaryExpressionEditable();
        }
    }

    class SelectLogicalExpressionAction
    extends AbstractAction {
        SelectLogicalExpressionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ConditionEditorView.this.setLogicalExpressionEditable();
        }
    }

    class SelectBasicExpressionAction
    extends AbstractAction {
        SelectBasicExpressionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ConditionEditorView.this.setBasicExpressionEditable();
        }
    }

    class SelectExceptionAction
    extends AbstractAction {
        SelectExceptionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ConditionEditorView.this.setConditionEditable(false);
        }
    }

    class SelectOtherwiseAction
    extends AbstractAction {
        SelectOtherwiseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ConditionEditorView.this.setConditionEditable(false);
        }
    }

    class SelectConditionAction
    extends AbstractAction {
        SelectConditionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ConditionEditorView.this.setConditionEditable(true);
        }
    }
}

