/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.ElementInspectorManager;
import jp.co.argo21.nautica.tool.wfd.InspectorManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.inspector.AbstractElementInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.ChangeElementListener;
import jp.co.argo21.nautica.tool.wfd.inspector.Inspector;

public class InspectorDialog
extends JDialog {
    private static InspectorManager manager = new ElementInspectorManager();
    private Inspector inspector;

    public static Element showDialog(Component c, Element elem) {
        Frame frame = JOptionPane.getFrameForComponent(c);
        InspectorDialog dialog = new InspectorDialog(frame, elem);
        dialog.setVisible(true);
        Element result = dialog.inspector.getInspectable();
        dialog.dispose();
        return result;
    }

    public static Element showDialog(Component c, String elemType) {
        Frame frame = JOptionPane.getFrameForComponent(c);
        InspectorDialog dialog = new InspectorDialog(frame, elemType);
        dialog.setVisible(true);
        Element result = dialog.inspector.getInspectable();
        dialog.dispose();
        return result;
    }

    public static void addChangeElementListener(String elemType, ChangeElementListener l) {
        Inspector i = manager.getInspectorForName(elemType);
        if (i instanceof AbstractElementInspector) {
            ((AbstractElementInspector)i).addChangeElementListener(l);
        }
    }

    public static void removeChangeElementListener(String elemType, ChangeElementListener l) {
        Inspector i = manager.getInspectorForName(elemType);
        if (i instanceof AbstractElementInspector) {
            ((AbstractElementInspector)i).removeChangeElementListener(l);
        }
    }

    private InspectorDialog(Frame frame, Element elem) {
        super(frame, true);
        if (elem == null) {
            this.inspector = manager.getDefaultInspector();
        } else {
            String inspectorName = ElementInspectorManager.getInspectorKey(elem);
            this.inspector = manager.getInspectorForName(inspectorName);
        }
        this.inspector.init();
        this.inspector.setInspectable(elem);
        this.createDialog();
        this.setLocationRelativeTo(frame);
    }

    private InspectorDialog(Frame frame, String elemType) {
        super(frame, true);
        this.inspector = elemType == null ? manager.getDefaultInspector() : manager.getInspectorForName(elemType);
        this.inspector.init();
        this.inspector.setInspectable(null);
        this.createDialog();
        this.setLocationRelativeTo(frame);
    }

    private void createDialog() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.setTitle(rm.getResource("InspectorDialog.title"));
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView((JComponent)((Object)this.inspector));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2, 10, 10));
        CloseAction listener = new CloseAction();
        if (this.inspector.isAutoCommit()) {
            JButton closeButton = new JButton(rm.getResource("JButton.label.close"));
            closeButton.addActionListener(listener);
            this.getRootPane().setDefaultButton(closeButton);
            buttonPane.add(closeButton);
        } else {
            JButton setButton = new JButton(rm.getResource("JButton.label.set"));
            setButton.setActionCommand("OK_OPTION");
            setButton.addActionListener(listener);
            this.getRootPane().setDefaultButton(setButton);
            buttonPane.add(setButton);
            JButton cancelButton = new JButton(rm.getResource("JButton.label.cancel"));
            cancelButton.addActionListener(listener);
            buttonPane.add(cancelButton);
        }
        Container contentPane = this.getContentPane();
        contentPane.add((Component)scroll, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.pack();
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if ("OK_OPTION".equals(e.getActionCommand())) {
                if (!InspectorDialog.this.inspector.check()) {
                    return;
                }
                InspectorDialog.this.inspector.commit();
            }
            InspectorDialog.this.inspector.unload();
            InspectorDialog.this.setVisible(false);
        }
    }
}

