/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class Ruler
extends JComponent {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final Font NUM_FONT = new Font("MonoSpaced", 0, 10);
    private static final Border border = BorderFactory.createRaisedBevelBorder();
    private int orientation = 0;
    private int unit = 100;

    public Ruler(int orientation, int unit) {
        this.orientation = orientation;
        this.unit = unit;
        this.setPreferredSize(new Dimension(15, 15));
    }

    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        g.setFont(NUM_FONT);
        FontMetrics metrics = g.getFontMetrics();
        int fontH = metrics.getHeight();
        int descent = metrics.getDescent();
        g.setColor(Color.black);
        if (this.orientation == 1) {
            for (int i = 0; i < size.height; ++i) {
                int y = i * this.unit;
                border.paintBorder(this, g, 0, y, size.width, this.unit);
                String num = "" + (i + 1);
                int lineW = metrics.stringWidth(num);
                int dx = (size.width - lineW) / 2;
                int dy = y + (this.unit - fontH) / 2 + fontH - descent;
                g.drawString(num, dx, dy);
            }
        } else {
            int dy = (size.height - fontH) / 2 + fontH - descent;
            for (int i = 0; i < size.width; ++i) {
                int x = i * this.unit;
                border.paintBorder(this, g, x, 0, this.unit, size.height);
                String num = "" + (i + 1);
                int lineW = metrics.stringWidth(num);
                int dx = x + (this.unit - lineW) / 2;
                g.drawString(num, dx, dy);
            }
        }
        g.dispose();
    }
}

