/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.ValidationResultView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;

public class ValidationDialog
extends JDialog {
    private static final Font FONT = new Font("SansSerif", 0, 24);
    private static ValidationResultView resultView;
    private static JLabel noResultView;

    public static void showDialog(Component c, List results) {
        Frame frame = JOptionPane.getFrameForComponent(c);
        ValidationDialog dialog = new ValidationDialog(frame, results);
        dialog.setVisible(true);
        dialog.dispose();
    }

    private ValidationDialog(Frame frame, List results) {
        super(frame, true);
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.setTitle(rm.getResource("ValidationDialog.title"));
        JScrollPane scroll = new JScrollPane();
        if (results == null) {
            scroll.setViewportView(noResultView);
        } else {
            resultView.setResults(results);
            scroll.setViewportView(resultView);
        }
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2, 10, 10));
        CloseAction listener = new CloseAction();
        JButton closeButton = new JButton(rm.getResource("JButton.label.close"));
        closeButton.addActionListener(listener);
        this.getRootPane().setDefaultButton(closeButton);
        buttonPane.add(closeButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)scroll, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    static {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        resultView = new ValidationResultView();
        noResultView = new JLabel(rm.getResource("ValidationDialog.label.0"));
        noResultView.setPreferredSize(new Dimension(400, 200));
        noResultView.setFont(FONT);
        noResultView.setHorizontalAlignment(0);
        noResultView.setForeground(Color.gray);
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ValidationDialog.this.setVisible(false);
        }
    }
}

