/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.element.impl.ApplicationElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.ParticipantElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.ProcessElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.VariableElementImpl;
import org.wfmc.x2002.xpdl10.ApplicationDocument;
import org.wfmc.x2002.xpdl10.ApplicationsDocument;
import org.wfmc.x2002.xpdl10.DataFieldDocument;
import org.wfmc.x2002.xpdl10.DataFieldsDocument;
import org.wfmc.x2002.xpdl10.PackageDocument;
import org.wfmc.x2002.xpdl10.PackageHeaderDocument;
import org.wfmc.x2002.xpdl10.ParticipantDocument;
import org.wfmc.x2002.xpdl10.ParticipantsDocument;
import org.wfmc.x2002.xpdl10.RedefinableHeaderDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessesDocument;

public class PackageElementImpl
implements PackageElement {
    private static final String UNINITIALIZED_ID = "--UNINITIALIZED--";
    private String id;
    private String name;
    private String description;
    private String createdDate;
    private String version;
    private String author;
    private List participants = new ArrayList();
    private List applications = new ArrayList();
    private List variables = new ArrayList();
    private List processes = new ArrayList();

    public PackageElementImpl(String n) {
        this.setID(IDGenerator.generate("PK"));
        this.setName(n);
        this.setDescription("");
        this.setCreatedDate("");
        this.setVersion("1.0");
        this.setAuthor(System.getProperty("user.name"));
    }

    public PackageElementImpl(PackageDocument doc) {
        Element e;
        int i;
        int count;
        PackageDocument.Package p = doc.getPackage();
        String id = p.getId();
        if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
            this.setID(IDGenerator.generate("PK"));
        } else {
            this.setID(id);
        }
        this.setName(p.getName());
        PackageHeaderDocument.PackageHeader phd = p.getPackageHeader();
        this.setDescription(phd.getDescription());
        this.setCreatedDate(phd.getCreated());
        if (p.isSetRedefinableHeader()) {
            RedefinableHeaderDocument.RedefinableHeader rhd = p.getRedefinableHeader();
            this.setAuthor(rhd.getAuthor());
            this.setVersion(rhd.getVersion());
        }
        if (p.isSetApplications()) {
            ApplicationsDocument.Applications apps = p.getApplications();
            count = apps.sizeOfApplicationArray();
            for (i = 0; i < count; ++i) {
                ApplicationDocument.Application app = apps.getApplicationArray(i);
                e = new ApplicationElementImpl(app);
                this.addApplication((ApplicationElement)e);
            }
        }
        if (p.isSetParticipants()) {
            ParticipantsDocument.Participants pts = p.getParticipants();
            count = pts.sizeOfParticipantArray();
            for (i = 0; i < count; ++i) {
                ParticipantDocument.Participant pt = pts.getParticipantArray(i);
                e = new ParticipantElementImpl(pt);
                this.addParticipant((ParticipantElement)e);
            }
        }
        if (p.isSetDataFields()) {
            DataFieldsDocument.DataFields dfs = p.getDataFields();
            count = dfs.sizeOfDataFieldArray();
            for (i = 0; i < count; ++i) {
                DataFieldDocument.DataField df = dfs.getDataFieldArray(i);
                e = new VariableElementImpl(df);
                this.addVariable((VariableElement)e);
            }
        }
        if (p.isSetWorkflowProcesses()) {
            WorkflowProcessesDocument.WorkflowProcesses wps = p.getWorkflowProcesses();
            count = wps.sizeOfWorkflowProcessArray();
            for (i = 0; i < count; ++i) {
                WorkflowProcessDocument.WorkflowProcess proc = wps.getWorkflowProcessArray(i);
                e = new ProcessElementImpl(proc);
                this.addProcess((ProcessElement)e);
            }
        }
    }

    private void setID(String id) {
        this.id = id;
    }

    public void addApplication(ApplicationElement app) {
        this.applications.add(app);
    }

    public void addParticipant(ParticipantElement part) {
        this.participants.add(part);
    }

    public void addProcess(ProcessElement proc) {
        this.processes.add(proc);
    }

    public void addVariable(VariableElement var) {
        this.variables.add(var);
    }

    public void removeApplication(ApplicationElement app) {
        this.applications.remove(app);
    }

    public void removeParticipant(ParticipantElement part) {
        this.participants.remove(part);
    }

    public void removeProcess(ProcessElement proc) {
        this.processes.remove(proc);
    }

    public void removeVariable(VariableElement var) {
        this.variables.remove(var);
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getApplications() {
        return this.applications;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public List getParticipants() {
        return this.participants;
    }

    public List getProcesses() {
        return this.processes;
    }

    public List getVariables() {
        return this.variables;
    }

    public String getVersion() {
        return this.version;
    }

    public void setCreatedDate(String s) {
        this.createdDate = s;
    }

    public void setVersion(String s) {
        this.version = s;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String s) {
        this.author = s;
    }

    public String getTooltipText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        s = s.append("<html>");
        s = s.append("<b>").append(this.getName()).append("</b>");
        s = s.append("<table border>");
        s = s.append("<tr><td width=100>").append(rm.getResource("PackageElement.label.0")).append("</td><td width=150>").append(this.getID()).append("</td></tr>");
        s = s.append("<tr><td width=100>").append(rm.getResource("PackageElement.label.5")).append("</td><td width=150>").append(this.getDescription()).append("</td></tr>");
        s = s.append("</table>");
        s = s.append("</html>");
        return s.toString();
    }

    public String getPrintText(ResourceManager rm) {
        StringBuffer s = new StringBuffer();
        return s.toString();
    }

    public boolean isUsed(Element elem) {
        if (elem == null) {
            return false;
        }
        Iterator it = this.processes.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            boolean isUsed = e.isUsed(elem);
            if (!isUsed) continue;
            return true;
        }
        return false;
    }
}

