/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.inspector.AbstractElementInspector;

public class PackageInspector
extends AbstractElementInspector {
    protected static final Border border = BorderFactory.createEtchedBorder();
    private IconView iconView;
    private JLabel idField;
    private JTextField nameField;
    private JTextField authorField;
    private JTextField createField;
    private JTextField versionField;
    private JTextField descriptionField;

    public PackageInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel = this.createBasicInfoPanel(rm);
        this.addTab(rm.getResource("PackageInspector.tab.0"), panel);
        this.validate();
    }

    private JPanel createBasicInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 200);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("PackageInspector.label.0"));
        JLabel l1 = new JLabel(rm.getResource("PackageInspector.label.1"));
        JLabel l2 = new JLabel(rm.getResource("PackageInspector.label.2"));
        JLabel l3 = new JLabel(rm.getResource("PackageInspector.label.3"));
        JLabel l4 = new JLabel(rm.getResource("PackageInspector.label.4"));
        JLabel l5 = new JLabel(rm.getResource("PackageInspector.label.5"));
        this.iconView = new IconView();
        this.iconView.setIconName("package");
        this.idField = new JLabel();
        this.idField.setBorder(border);
        this.nameField = new JTextField();
        this.nameField.setDocument(new ByteLimitedDocument(64));
        this.authorField = new JTextField();
        this.authorField.setDocument(new ByteLimitedDocument(64));
        this.versionField = new JTextField();
        this.versionField.setDocument(new ByteLimitedDocument(20));
        this.createField = new JTextField();
        this.createField.setDocument(new ByteLimitedDocument(20));
        this.descriptionField = new JTextField();
        this.descriptionField.setDocument(new ByteLimitedDocument(128));
        panel.add(this.locate(this.iconView, 10, 10, 60, 60));
        panel.add(this.locate(l0, 80, 10, 100, 25));
        panel.add(this.locate(l1, 80, 40, 100, 25));
        panel.add(this.locate(l2, 80, 70, 100, 25));
        panel.add(this.locate(l3, 80, 100, 100, 25));
        panel.add(this.locate(l4, 80, 130, 100, 25));
        panel.add(this.locate(l5, 80, 160, 100, 25));
        panel.add(this.locate(this.idField, 180, 10, 190, 25));
        panel.add(this.locate(this.nameField, 180, 40, 190, 25));
        panel.add(this.locate(this.authorField, 180, 70, 190, 25));
        panel.add(this.locate(this.createField, 180, 100, 190, 25));
        panel.add(this.locate(this.versionField, 180, 130, 190, 25));
        panel.add(this.locate(this.descriptionField, 180, 160, 190, 25));
        this.validate();
        return panel;
    }

    public void init() {
        super.init();
        this.nameField.setText("");
        this.descriptionField.setText("");
    }

    public void setInspectable(Element elem) {
        super.setInspectable(elem);
        if (elem != null && elem instanceof PackageElement) {
            PackageElement act = (PackageElement)elem;
            this.idField.setText(act.getID());
            this.nameField.setText(act.getName());
            this.authorField.setText(act.getAuthor());
            this.createField.setText(act.getCreatedDate());
            this.versionField.setText(act.getVersion());
            this.descriptionField.setText(act.getDescription());
        }
        this.setSelectedIndex(0);
    }

    public boolean check() {
        return true;
    }

    public void commit() {
        Element e = this.getInspectable();
        if (e != null && e instanceof PackageElement) {
            PackageElement pkg = (PackageElement)e;
            pkg.setName(this.nameField.getText());
            pkg.setAuthor(this.authorField.getText());
            pkg.setCreatedDate(this.createField.getText());
            pkg.setVersion(this.versionField.getText());
            pkg.setDescription(this.descriptionField.getText());
            this.fireElementChanged();
        }
    }

    protected Component locate(Component component, int x, int y, int w, int h) {
        component.setLocation(x, y);
        component.setSize(w, h);
        return component;
    }
}

