/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.DesktopPane;
import jp.co.argo21.nautica.tool.wfd.ElementReceivableView;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignFrame;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.inspector.ChangeElementListener;
import jp.co.argo21.nautica.tool.wfd.inspector.MappedParam;
import jp.co.argo21.nautica.tool.wfd.inspector.ParamMappingTableModel;
import jp.co.argo21.nautica.tool.wfd.inspector.ProcessInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.TransitionalActivityInspector;

public class SubprocessActivityInspector
extends TransitionalActivityInspector {
    private JTextField limitField;
    private JLabel unitField;
    private ElementReceivableView subprocIconField;
    private JLabel subprocIDField;
    private JLabel subprocNameField;
    private JTable paramTable;
    private ElementReceivableView varIconField;
    private JButton unbindButton;
    private JRadioButton syncButton;
    private JRadioButton asyncButton;
    private JTextField engineField;
    private ParamMappingTableModel paramModel;
    private ChangeProcessElementAction changeProcAction;
    private ChangeVariableElementAction changeVarAction;
    private ProcessElement subproc;

    public SubprocessActivityInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        this.changeProcAction = new ChangeProcessElementAction();
        this.changeVarAction = new ChangeVariableElementAction();
        JPanel panel1 = this.createLimitInfoPanel(rm);
        this.addTab(rm.getResource("SubprocessActivityInspector.tab.0"), panel1);
        JPanel panel2 = this.createSubprocessInfoPanel(rm);
        this.addTab(rm.getResource("SubprocessActivityInspector.tab.1"), panel2);
        this.validate();
    }

    private JPanel createLimitInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createEtchedBorder(1));
        Dimension size = new Dimension(380, 50);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("SubprocessActivityInspector.label.0"));
        this.limitField = new JTextField();
        this.limitField.setHorizontalAlignment(4);
        this.limitField.setDocument(new NumericDocument(3, true, true));
        this.unitField = new JLabel();
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(this.limitField, 110, 10, 70, 25));
        panel.add(this.locate(this.unitField, 180, 10, 70, 25));
        this.validate();
        return panel;
    }

    private JPanel createSubprocessInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createEtchedBorder(1));
        Dimension size = new Dimension(380, 420);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("SubprocessActivityInspector.label.1"));
        JLabel l1 = new JLabel(rm.getResource("SubprocessActivityInspector.label.2"));
        JLabel l2 = new JLabel(rm.getResource("SubprocessActivityInspector.label.3"));
        JLabel l3 = new JLabel(rm.getResource("SubprocessActivityInspector.label.4"));
        JLabel l4 = new JLabel(rm.getResource("SubprocessActivityInspector.label.5"));
        JLabel l5 = new JLabel(rm.getResource("SubprocessActivityInspector.label.6"));
        this.subprocIconField = new ElementReceivableView("process");
        this.subprocIconField.addChangeElementListener(this.changeProcAction);
        this.subprocIDField = new JLabel();
        this.subprocIDField.setBorder(border);
        this.subprocNameField = new JLabel();
        this.subprocNameField.setBorder(border);
        this.paramModel = new ParamMappingTableModel();
        this.paramTable = new JTable(this.paramModel);
        this.paramTable.setSelectionMode(0);
        ListSelectionModel selectModel = this.paramTable.getSelectionModel();
        selectModel.addListSelectionListener(new SelectParamTableAction());
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.paramTable);
        this.varIconField = new ElementReceivableView("variable");
        this.varIconField.addChangeElementListener(this.changeVarAction);
        this.unbindButton = new JButton(rm.getResource("JButton.label.unbind"));
        this.unbindButton.addActionListener(new UnbindParamAction());
        this.syncButton = new JRadioButton(rm.getResource("SubprocessActivityInspector.label.7"));
        this.asyncButton = new JRadioButton(rm.getResource("SubprocessActivityInspector.label.8"));
        this.engineField = new JTextField();
        this.engineField.setDocument(new ByteLimitedDocument(64));
        this.syncButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.syncButton);
        group.add(this.asyncButton);
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(this.subprocIconField, 10, 40, 60, 60));
        panel.add(this.locate(l1, 80, 42, 100, 25));
        panel.add(this.locate(l2, 80, 72, 100, 25));
        panel.add(this.locate(this.subprocIDField, 180, 42, 190, 25));
        panel.add(this.locate(this.subprocNameField, 180, 72, 190, 25));
        panel.add(this.locate(l3, 10, 100, 250, 25));
        panel.add(this.locate(sp, 10, 130, 270, 160));
        panel.add(this.locate(this.varIconField, 300, 130, 60, 60));
        panel.add(this.locate(this.unbindButton, 290, 200, 80, 25));
        panel.add(this.locate(l4, 10, 290, 100, 25));
        panel.add(this.locate(this.syncButton, 10, 320, 100, 25));
        panel.add(this.locate(this.asyncButton, 140, 320, 100, 25));
        panel.add(this.locate(l5, 10, 350, 100, 25));
        panel.add(this.locate(this.engineField, 10, 380, 200, 25));
        this.validate();
        return panel;
    }

    public void commit() {
        super.commit();
        Element e = this.getInspectable();
        if (e != null && e instanceof ActivityElement) {
            ActivityElement act = (ActivityElement)e;
            try {
                int limit = Integer.parseInt(this.limitField.getText());
                act.setLimit(limit);
            }
            catch (Exception ex) {
                act.setLimit(0);
            }
            if (this.subproc != null) {
                act.setSubprocessID(this.subproc.getID());
                act.getSubprocessParameters().clear();
                Iterator pit = this.paramModel.getAllMappedParams().iterator();
                while (pit.hasNext()) {
                    MappedParam mp = (MappedParam)pit.next();
                    VariableElement v = mp.getActualParam();
                    if (v == null) {
                        act.addSubprocessParameterID("");
                        continue;
                    }
                    act.addSubprocessParameterID(v.getID());
                }
                act.setEngineName(this.engineField.getText());
            } else {
                act.setSubprocessID(null);
                act.getSubprocessParameters().clear();
            }
            if (this.asyncButton.isSelected()) {
                act.setExecution(1);
            } else {
                act.setExecution(2);
            }
        }
    }

    public final void setInspectable(Element elem) {
        super.setInspectable(elem);
        if (elem != null) {
            DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
            ProcessDesignFrame frame = desktop.getCurrentProcessDesignFrame();
            if (frame == null) {
                return;
            }
            if (elem instanceof ActivityElement) {
                this.updateDurationUnit(null);
                PackageElement pkg = WorkflowDesignerManager.getMainFrame().getPackage();
                ActivityElement act = (ActivityElement)elem;
                this.limitField.setText("" + act.getLimit());
                String pid = act.getSubprocessID();
                if (!StringUtils.checkNull(pid)) {
                    Iterator it = pkg.getProcesses().iterator();
                    while (it.hasNext()) {
                        ProcessElement e = (ProcessElement)it.next();
                        if (!pid.equals(e.getID())) continue;
                        this.subproc = e;
                        break;
                    }
                    this.subprocIconField.setElement(this.subproc);
                    this.updateProcessInfo();
                    if (this.subproc != null) {
                        List params = act.getSubprocessParameters();
                        block1: for (int i = 0; i < params.size(); ++i) {
                            String vid = (String)params.get(i);
                            if (StringUtils.checkNull(vid)) continue;
                            Iterator vit = pkg.getVariables().iterator();
                            while (vit.hasNext()) {
                                VariableElement e = (VariableElement)vit.next();
                                if (!vid.equals(e.getID())) continue;
                                this.paramModel.updateMapping(i, e);
                                continue block1;
                            }
                        }
                        this.engineField.setText(act.getEngineName());
                    }
                }
                if (act.getExecution() == 1) {
                    this.asyncButton.setSelected(true);
                } else {
                    this.syncButton.setSelected(true);
                }
            }
        }
    }

    public void init() {
        super.init();
        this.limitField.setText("0");
        this.unitField.setText("");
        this.subprocIDField.setText("");
        this.subprocNameField.setText("");
        this.subprocIconField.setElement(null);
        this.varIconField.setElement(null);
        this.syncButton.setSelected(true);
        this.paramModel.clearAllParams();
        this.subproc = null;
        this.engineField.setText("");
        InspectorDialog.addChangeElementListener("process", this.changeProcAction);
        InspectorDialog.addChangeElementListener("variable", this.changeVarAction);
    }

    public void unload() {
        InspectorDialog.removeChangeElementListener("process", this.changeProcAction);
        InspectorDialog.removeChangeElementListener("variable", this.changeVarAction);
    }

    private void updateProcessInfo() {
        if (this.subproc != null) {
            this.subprocIDField.setText(this.subproc.getID());
            this.subprocNameField.setText(this.subproc.getName());
            this.paramModel.initParams(this.subproc.getParameters());
        }
    }

    private void updateDurationUnit(ProcessElement p) {
        int u;
        ProcessElement proc = p;
        if (proc == null) {
            DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
            ProcessDesignFrame frame = desktop.getCurrentProcessDesignFrame();
            if (frame == null) {
                return;
            }
            proc = frame.getProcess();
        }
        if ((u = proc.getDurationUnit()) == 1) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[0]);
        } else if (u == 2) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[1]);
        } else if (u == 3) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[2]);
        } else if (u == 4) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[3]);
        } else if (u == 5) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[4]);
        } else if (u == 6) {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[5]);
        } else {
            this.unitField.setText(ProcessInspector.DURATION_UNITS[2]);
        }
    }

    private void updateVariableInfo() {
        this.paramModel.fireTableDataChanged();
    }

    private void updateVariableInfo(VariableElement var) {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        int selected = this.paramTable.getSelectedRow();
        if (selected < 0) {
            DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
            this.varIconField.setElement(null);
            return;
        }
        if (var != null) {
            int aptype;
            if (!var.isInitialized()) {
                DialogUtilities.showError(rm.getResource("message.error.0028"));
                this.varIconField.setElement(null);
                return;
            }
            MappedParam mp = this.paramModel.getMappedParam(selected);
            int ptype = mp.getParam().getType();
            if (ptype != (aptype = var.getType())) {
                DialogUtilities.showError(rm.getResource("message.error.0029"));
                this.varIconField.setElement(null);
                return;
            }
            this.paramModel.updateMapping(selected, var);
        }
        this.paramModel.fireTableRowsUpdated(selected, selected);
        this.varIconField.setElement(null);
    }

    private void unbindSelectedMapping() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        int selected = this.paramTable.getSelectedRow();
        if (selected < 0) {
            DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
            this.varIconField.setElement(null);
            return;
        }
        this.paramModel.removeMapping(selected);
        this.varIconField.setElement(null);
    }

    private void showVariableIcon() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        int selected = this.paramTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        MappedParam mp = this.paramModel.getMappedParam(selected);
        if (mp != null) {
            this.varIconField.setElement(mp.getActualParam());
        }
    }

    class ChangeVariableElementAction
    implements ChangeElementListener {
        ChangeVariableElementAction() {
        }

        public void elementChanged(Element elem) {
            SubprocessActivityInspector.this.updateVariableInfo();
        }

        public void elementDropped(Element elem) {
            if (elem instanceof VariableElement) {
                SubprocessActivityInspector.this.updateVariableInfo((VariableElement)elem);
            }
        }
    }

    class ChangeProcessElementAction
    implements ChangeElementListener {
        ChangeProcessElementAction() {
        }

        public void elementChanged(Element elem) {
            SubprocessActivityInspector.this.updateProcessInfo();
            SubprocessActivityInspector.this.updateDurationUnit((ProcessElement)elem);
        }

        public void elementDropped(Element elem) {
            if (elem instanceof ProcessElement) {
                SubprocessActivityInspector.this.subproc = (ProcessElement)elem;
                SubprocessActivityInspector.this.updateProcessInfo();
            }
        }
    }

    class UnbindParamAction
    implements ActionListener {
        UnbindParamAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SubprocessActivityInspector.this.unbindSelectedMapping();
        }
    }

    class SelectParamTableAction
    implements ListSelectionListener {
        SelectParamTableAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            SubprocessActivityInspector.this.showVariableIcon();
        }
    }
}

