/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.ConditionDialog;
import jp.co.argo21.nautica.tool.wfd.DesktopPane;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignFrame;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.expression.ExceptionExpression;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;
import jp.co.argo21.nautica.tool.wfd.expression.OtherwiseExpression;
import jp.co.argo21.nautica.tool.wfd.inspector.BasicActivityInspector;

public class TransitionalActivityInspector
extends BasicActivityInspector {
    private static String[] columnNames;
    private static String[] conditionTypes;
    private JButton editCondButton;
    private JTable transitionTable;
    private JTextArea conditionArea;
    private List transitions = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;

    public TransitionalActivityInspector() {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        JPanel panel = this.createTransitionInfoPanel(rm);
        this.addTab(rm.getResource("TransitionalActivityInspector.tab.0"), panel);
        this.validate();
    }

    private JPanel createTransitionInfoPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(380, 380);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("TransitionalActivityInspector.label.0"));
        JLabel l1 = new JLabel(rm.getResource("TransitionalActivityInspector.label.1"));
        this.transitionTable = new JTable(new TransitionTableModel());
        this.transitionTable.setSelectionMode(0);
        ListSelectionModel tlsm = this.transitionTable.getSelectionModel();
        tlsm.addListSelectionListener(new TransitionSelectAction());
        JScrollPane sp1 = new JScrollPane();
        sp1.setViewportView(this.transitionTable);
        this.conditionArea = new JTextArea();
        this.conditionArea.setLineWrap(true);
        this.conditionArea.setEditable(false);
        JScrollPane sp2 = new JScrollPane();
        sp2.setViewportView(this.conditionArea);
        JButton editButton = new JButton(rm.getResource("JButton.label.edit"));
        editButton.addActionListener(new EditTransitionAction());
        panel.add(this.locate(l0, 10, 10, 100, 25));
        panel.add(this.locate(sp1, 10, 40, 360, 155));
        panel.add(this.locate(l1, 10, 200, 100, 25));
        panel.add(this.locate(sp2, 10, 230, 270, 105));
        panel.add(this.locate(editButton, 290, 230, 80, 25));
        this.validate();
        return panel;
    }

    public void init() {
        super.init();
        this.transitions.clear();
        this.conditionArea.setText("");
    }

    public void commit() {
        super.commit();
        Element e = this.getInspectable();
        if (e != null && e instanceof ActivityElement) {
            ActivityElement activityElement = (ActivityElement)e;
        }
    }

    public void setInspectable(Element elem) {
        super.setInspectable(elem);
        if (elem != null && elem instanceof ActivityElement) {
            ActivityElement act = (ActivityElement)elem;
            DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
            ProcessDesignFrame frame = desktop.getCurrentProcessDesignFrame();
            if (frame == null) {
                return;
            }
            ProcessElement proc = frame.getProcess();
            if (proc == null) {
                return;
            }
            Iterator tit = proc.getTransitions().iterator();
            while (tit.hasNext()) {
                TransitionElement t = (TransitionElement)tit.next();
                if (act != t.getSource()) continue;
                this.transitions.add(t);
            }
        }
        this.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ResourceManager rm = WorkflowDesignerManager.getResourceManager();
        columnNames = new String[2];
        TransitionalActivityInspector.columnNames[0] = rm.getResource("TransitionTableModel.columnName.0");
        TransitionalActivityInspector.columnNames[1] = rm.getResource("TransitionTableModel.columnName.1");
        conditionTypes = new String[5];
        TransitionalActivityInspector.conditionTypes[0] = rm.getResource("TransitionTableModel.conditionType.0");
        TransitionalActivityInspector.conditionTypes[1] = rm.getResource("TransitionTableModel.conditionType.1");
        TransitionalActivityInspector.conditionTypes[2] = rm.getResource("TransitionTableModel.conditionType.2");
        TransitionalActivityInspector.conditionTypes[3] = rm.getResource("TransitionTableModel.conditionType.3");
        TransitionalActivityInspector.conditionTypes[4] = rm.getResource("TransitionTableModel.conditionType.4");
    }

    class TransitionTableModel
    extends AbstractTableModel {
        TransitionTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return TransitionalActivityInspector.this.transitions.size();
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            TransitionElement tr = (TransitionElement)TransitionalActivityInspector.this.transitions.get(row);
            if (col == 0) {
                return tr.getDestination().getName();
            }
            int type = tr.getType();
            if (type == 2) {
                return conditionTypes[1];
            }
            if (type == 3) {
                return conditionTypes[2];
            }
            if (type == 4) {
                return conditionTypes[3];
            }
            if (tr.getCondition() == null) {
                return conditionTypes[4];
            }
            return conditionTypes[0];
        }

        public Class getColumnClass(int col) {
            return class$java$lang$String == null ? (class$java$lang$String = TransitionalActivityInspector.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class TransitionSelectAction
    implements ListSelectionListener {
        TransitionSelectAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selected = lsm.getMinSelectionIndex();
                Expression exp = ((TransitionElement)TransitionalActivityInspector.this.transitions.get(selected)).getCondition();
                if (exp != null) {
                    List vars = WorkflowDesignerManager.getMainFrame().getPackage().getVariables();
                    TransitionalActivityInspector.this.conditionArea.setText(exp.getExpressionString(vars));
                } else {
                    TransitionalActivityInspector.this.conditionArea.setText("");
                }
            }
        }
    }

    class EditTransitionAction
    extends AbstractAction {
        EditTransitionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowDesignerManager.getResourceManager();
            int selected = TransitionalActivityInspector.this.transitionTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("message.warn.0004"));
                return;
            }
            TransitionElement tr = (TransitionElement)TransitionalActivityInspector.this.transitions.get(selected);
            Expression exp = tr.getCondition();
            Expression newExp = ConditionDialog.showDialog(TransitionalActivityInspector.this, exp);
            if (newExp == null) {
                tr.setType(1);
            } else if (newExp instanceof OtherwiseExpression) {
                tr.setType(2);
            } else if (newExp instanceof ExceptionExpression) {
                tr.setType(3);
            } else {
                tr.setType(1);
            }
            tr.setCondition(newExp);
            TransitionalActivityInspector.this.transitionTable.clearSelection();
            TransitionalActivityInspector.this.conditionArea.setText("");
        }
    }
}

