/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.print;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import jp.co.argo21.nautica.tool.wfd.ProcessFlowView;

public class PrintData
implements Pageable {
    private PageFormat format = new PageFormat();
    private ProcessFlowView view;

    public PrintData(ProcessFlowView view) {
        this.view = view;
    }

    public void setFormat(PageFormat format) {
        this.format = format;
    }

    public int getNumberOfPages() {
        return 1;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.format;
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return new FlowPage();
    }

    class FlowPage
    implements Printable {
        FlowPage() {
        }

        public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
            Dimension psize = PrintData.this.view.getPreferredSize();
            boolean needToRotate = false;
            if (psize.width > psize.height) {
                needToRotate = true;
            }
            double xScale = format.getImageableWidth() / (double)psize.width;
            double yScale = format.getImageableHeight() / (double)psize.height;
            if (needToRotate) {
                xScale = format.getImageableHeight() / (double)psize.width;
                yScale = format.getImageableWidth() / (double)psize.height;
            }
            double scale = 1.0;
            scale = xScale < yScale ? xScale : yScale;
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform tr = g2.getTransform();
            if (needToRotate) {
                g2.translate(0.0, format.getHeight());
                g2.rotate(Math.toRadians(-90.0));
            }
            g2.translate(format.getImageableX(), format.getImageableY());
            g2.scale(scale, scale);
            PrintData.this.view.paintView(g2);
            g2.setTransform(tr);
            return 0;
        }
    }
}

