/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfd.sim;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Timer;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;
import jp.co.argo21.nautica.tool.wfd.sim.SimulatableActivityWrapper;
import jp.co.argo21.nautica.tool.wfd.sim.SimulationListener;
import jp.co.argo21.nautica.tool.wfd.sim.SimulatorDialog;

public class SimurateManager {
    private static final int TIMER_DELAY = 1000;
    private static final int SIMULATION_PROGRESSED = 1;
    private static final int SIMULATION_FINISHED = 2;
    private static final int SIMULATION_TERMINATED = 3;
    private SimulatorDialog dialog = new SimulatorDialog();
    private SimulationListener listener;
    private ProcessElement proc;
    private SimulatableActivityWrapper wrapper;

    public void start(SimulationListener l, List vars, ProcessElement proc, SimulatableActivityWrapper act) {
        this.listener = l;
        this.proc = proc;
        this.wrapper = act;
        this.dialog.setCurrentActivity(act.getActivity());
        this.dialog.setCurrentVariables(vars);
        if (this.listener != null) {
            this.listener.simulationStarted(act);
        }
        this.simulate();
    }

    public void simulate(SimulatableActivityWrapper act) {
        this.wrapper = act;
        this.dialog.setCurrentActivity(act.getActivity());
        this.simulate();
    }

    private void simulate() {
        if (this.wrapper.getActivity().getType().equals("CONCUR_START") || this.wrapper.getActivity().getType().equals("CONCUR_END") || this.wrapper.getActivity().getType().equals("END")) {
            this.dialog.setValueEditable(false);
        } else {
            this.dialog.setValueEditable(true);
        }
        this.dialog.setVisible(true);
        if (this.dialog.getResult() == 1) {
            SimulateAction action = null;
            if (this.wrapper.getActivity().getType().equals("END")) {
                action = new SimulateAction(2);
            } else {
                boolean isExRaising;
                List vars = this.dialog.getCurrentVariables();
                List trs = this.evaluate(vars, isExRaising = this.dialog.isExceptionRaising());
                if (trs.size() == 0) {
                    action = new SimulateAction(3);
                    action.setSimulatedActivity(this.wrapper);
                } else {
                    action = new SimulateAction(1);
                    action.setSimulatedTransitions(trs);
                }
            }
            Timer timer = new Timer(1000, action);
            timer.setRepeats(false);
            timer.start();
        }
    }

    private List evaluate(List vars, boolean isExRaising) {
        ArrayList<TransitionElement> result = new ArrayList<TransitionElement>();
        ArrayList<TransitionElement> otherwises = new ArrayList<TransitionElement>();
        boolean isConcurrent = false;
        if (this.wrapper.getActivity().getType().equals("CONCUR_START")) {
            isConcurrent = true;
        }
        Iterator tit = this.proc.getTransitions().iterator();
        while (tit.hasNext()) {
            TransitionElement tr = (TransitionElement)tit.next();
            if (this.wrapper.getActivity() != tr.getSource()) continue;
            Expression exp = tr.getCondition();
            int type = tr.getType();
            if (type == 3) {
                if (!isExRaising) continue;
                result.add(tr);
                if (isConcurrent) continue;
                break;
            }
            if (type == 2) {
                otherwises.add(tr);
                continue;
            }
            if (exp == null) {
                result.add(tr);
                if (isConcurrent) continue;
                break;
            }
            if (!exp.eval(vars)) continue;
            result.add(tr);
            if (isConcurrent) continue;
            break;
        }
        if (result.size() == 0 && otherwises.size() > 0) {
            if (isConcurrent) {
                result = otherwises;
            } else {
                result.add((TransitionElement)otherwises.get(0));
            }
        }
        return result;
    }

    class SimulateAction
    extends AbstractAction {
        private int state;
        private SimulatableActivityWrapper simact;
        private List simtrs;

        SimulateAction(int s) {
            this.state = s;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.state == 1) {
                this.fireSimulationProgressed();
            } else if (this.state == 2) {
                this.fireSimulationFinished();
            } else if (this.state == 3) {
                this.fireSimulationTerminated();
            }
        }

        void setSimulatedActivity(SimulatableActivityWrapper a) {
            this.simact = a;
        }

        void setSimulatedTransitions(List trs) {
            this.simtrs = trs;
        }

        private void fireSimulationProgressed() {
            if (SimurateManager.this.listener != null) {
                SimurateManager.this.listener.simulationProgressed(SimurateManager.this.wrapper, this.simtrs);
            }
        }

        private void fireSimulationFinished() {
            if (SimurateManager.this.listener != null) {
                SimurateManager.this.listener.simulationFinished(this.simact);
            }
        }

        private void fireSimulationTerminated() {
            if (SimurateManager.this.listener != null) {
                SimurateManager.this.listener.simulationTerminated(this.simact);
            }
        }
    }
}

