/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.commons.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;

public final class ExceptionFrame
extends JInternalFrame {
    private static final String BUNDLE_PATH = "jp.co.argo21.commons.resources.commons";
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS =======================================\n");
    private static ResourceBundle resources;
    private JPanel panel = new JPanel();
    private JTextArea codeArea = new JTextArea();
    private JScrollPane scrollPane = new JScrollPane();
    private JPanel buttonPanel = new JPanel();
    private JButton clearButton = new JButton();
    private JButton closeButton = new JButton();
    private BorderLayout layout = new BorderLayout();
    private boolean isExit = false;

    public ExceptionFrame() {
        super(ExceptionFrame.getResourceString("ExceptionViewer.title", "Exception Viewer"), false, true);
        this.setLayer(JLayeredPane.POPUP_LAYER);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = new Dimension((int)((double)screenSize.width * 0.8), (int)((double)screenSize.height * 0.8));
        this.setBounds((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2, frameSize.width, frameSize.height);
        this.panel.setLayout(this.layout);
        this.panel.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 204), 4));
        this.codeArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.codeArea.setEditable(false);
        JViewport viewport = this.scrollPane.getViewport();
        viewport.add((Component)this.codeArea, null);
        this.buttonPanel.setOpaque(false);
        this.clearButton.setText(ExceptionFrame.getResourceString("ExceptionViewer.clearButton.text", "Clear"));
        this.clearButton.setRolloverEnabled(true);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExceptionFrame.this.clear();
            }
        });
        this.buttonPanel.add((Component)this.clearButton, null);
        this.closeButton.setText(ExceptionFrame.getResourceString("ExceptionViewer.closeButton.text", "Close"));
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExceptionFrame.this.close();
            }
        });
        this.buttonPanel.add((Component)this.closeButton, null);
        this.panel.add((Component)this.scrollPane, "Center");
        this.panel.add((Component)this.buttonPanel, "South");
        this.setContentPane(this.panel);
    }

    public void setThrowable(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this.setThrowable(throwable.getCause());
        int len = this.codeArea.getText().length();
        this.codeArea.setCaretPosition(len);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        String trace = sw.toString();
        pw.close();
        Date date = new Date();
        this.codeArea.append(formatter.format(date));
        this.codeArea.append(trace);
        this.codeArea.append("\n");
        this.codeArea.setCaretPosition(len);
        this.repaint();
    }

    public void setMessage(String message) {
        if (message == null) {
            return;
        }
        int len = this.codeArea.getText().length();
        this.codeArea.setCaretPosition(len);
        Date date = new Date();
        this.codeArea.append(formatter.format(date));
        this.codeArea.append(message);
        this.codeArea.append("\n");
        this.repaint();
    }

    private void clear() {
        this.codeArea.setText("");
    }

    private void close() {
        this.setVisible(false);
        if (this.isExit) {
            System.exit(0);
        }
    }

    private static String getResourceString(String key, String alt) {
        try {
            return resources.getString(key);
        }
        catch (Exception ex) {
            return alt;
        }
    }

    static {
        try {
            resources = ResourceBundle.getBundle(BUNDLE_PATH);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
        }
    }
}

