/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.commons.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;

public final class ExceptionViewer
extends JDialog {
    private static final String BUNDLE_PATH = "jp.co.argo21.commons.resources.commons";
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS =======================================\n");
    private static ResourceBundle resources;
    private JPanel panel = new JPanel();
    private JTextArea codeArea = new JTextArea();
    private JScrollPane scrollPane = new JScrollPane();
    private JPanel buttonPanel = new JPanel();
    private JButton clearButton = new JButton();
    private JButton closeButton = new JButton();
    private BorderLayout layout = new BorderLayout();
    private boolean isExit = false;

    public ExceptionViewer(Frame frame, boolean isExit) {
        super(frame);
        this.isExit = isExit;
        this.setTitle(this.getResourceString("ExceptionViewer.title", "Exception Viewer"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ExceptionViewer.this.close();
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = new Dimension((int)((double)screenSize.width * 0.8), (int)((double)screenSize.height * 0.8));
        this.setBounds((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2, frameSize.width, frameSize.height);
        this.panel.setLayout(this.layout);
        this.panel.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 204), 4));
        this.codeArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.codeArea.setEditable(false);
        JViewport viewport = this.scrollPane.getViewport();
        viewport.add((Component)this.codeArea, null);
        this.buttonPanel.setOpaque(false);
        this.clearButton.setText(this.getResourceString("ExceptionViewer.clearButton.text", "Clear"));
        this.clearButton.setRolloverEnabled(true);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExceptionViewer.this.clear();
            }
        });
        this.buttonPanel.add((Component)this.clearButton, null);
        this.closeButton.setText(this.getResourceString("ExceptionViewer.closeButton.text", "Close"));
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExceptionViewer.this.close();
            }
        });
        this.buttonPanel.add((Component)this.closeButton, null);
        this.panel.add((Component)this.scrollPane, "Center");
        this.panel.add((Component)this.buttonPanel, "South");
        this.setContentPane(this.panel);
    }

    public void setThrowable(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this.setThrowable(throwable.getCause());
        int len = this.codeArea.getText().length();
        this.codeArea.setCaretPosition(len);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        String trace = sw.toString();
        pw.close();
        Date date = new Date();
        this.codeArea.append(formatter.format(date));
        this.codeArea.append(trace);
        this.codeArea.append("\n");
        this.codeArea.setCaretPosition(len);
        this.repaint();
    }

    public void setMessage(String message) {
        if (message == null) {
            return;
        }
        int len = this.codeArea.getText().length();
        this.codeArea.setCaretPosition(len);
        Date date = new Date();
        this.codeArea.append(formatter.format(date));
        this.codeArea.append(message);
        this.codeArea.append("\n");
        this.repaint();
    }

    private void clear() {
        this.codeArea.setText("");
    }

    private void close() {
        this.setVisible(false);
        if (this.isExit) {
            System.exit(0);
        }
    }

    private String getResourceString(String key, String alt) {
        try {
            return resources.getString(key);
        }
        catch (Exception ex) {
            return alt;
        }
    }

    static {
        try {
            resources = ResourceBundle.getBundle(BUNDLE_PATH);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
        }
    }
}

