/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.commons.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class HelpViewer
extends JFrame {
    private static final String BUNDLE_PATH = "jp.co.argo21.commons.resources.commons";
    private static String PAGE_NOT_FOUND;
    private static ResourceBundle resources;
    private JList helpList;
    private BrowserPane browserPane;
    static /* synthetic */ Class class$jp$co$argo21$commons$swing$HelpViewer;

    public HelpViewer() {
        super(resources.getString("HelpViewer.title"));
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int sw = screen.width;
        int sh = screen.height;
        Dimension size = new Dimension(500, (int)((double)sh * 0.9));
        this.setSize(size);
        this.setLocation(sw - size.width, 0);
        this.browserPane = new BrowserPane();
        this.setContentPane(this.browserPane);
        this.validate();
    }

    public void loadResource(String path) {
        URL url = null;
        if (path != null) {
            url = (class$jp$co$argo21$commons$swing$HelpViewer == null ? (class$jp$co$argo21$commons$swing$HelpViewer = HelpViewer.class$("jp.co.argo21.commons.swing.HelpViewer")) : class$jp$co$argo21$commons$swing$HelpViewer).getResource(path);
        }
        if (url == null) {
            url = (class$jp$co$argo21$commons$swing$HelpViewer == null ? (class$jp$co$argo21$commons$swing$HelpViewer = HelpViewer.class$("jp.co.argo21.commons.swing.HelpViewer")) : class$jp$co$argo21$commons$swing$HelpViewer).getResource(PAGE_NOT_FOUND);
        }
        this.browserPane.loadURL(url);
    }

    public void loadURL(String urlpath) {
        URL url = null;
        try {
            url = new URL(urlpath);
        }
        catch (Exception ex) {
            url = (class$jp$co$argo21$commons$swing$HelpViewer == null ? (class$jp$co$argo21$commons$swing$HelpViewer = HelpViewer.class$("jp.co.argo21.commons.swing.HelpViewer")) : class$jp$co$argo21$commons$swing$HelpViewer).getResource(PAGE_NOT_FOUND);
        }
        this.browserPane.loadURL(url);
    }

    public void loadURL(URL url) {
        if (url == null) {
            url = (class$jp$co$argo21$commons$swing$HelpViewer == null ? (class$jp$co$argo21$commons$swing$HelpViewer = HelpViewer.class$("jp.co.argo21.commons.swing.HelpViewer")) : class$jp$co$argo21$commons$swing$HelpViewer).getResource(PAGE_NOT_FOUND);
        }
        this.browserPane.loadURL(url);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            resources = ResourceBundle.getBundle(BUNDLE_PATH);
            PAGE_NOT_FOUND = resources.getString("HelpViewer.nopage");
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
        }
    }

    private final class BrowserPane
    extends JScrollPane
    implements HyperlinkListener {
        private JEditorPane browser = new JEditorPane();

        private BrowserPane() {
            this.browser.setEditable(false);
            this.browser.addHyperlinkListener(this);
            JViewport vp = this.getViewport();
            vp.add(this.browser);
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.linkActivated(e.getURL());
            }
        }

        public void loadURL(URL u) {
            SwingUtilities.invokeLater(new PageLoader(u));
        }

        private void linkActivated(URL u) {
            SwingUtilities.invokeLater(new PageLoader(u));
        }

        private final class PageLoader
        implements Runnable {
            private URL url;

            PageLoader(URL u) {
                this.url = u;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (this.url == null) {
                    Container parent = BrowserPane.this.browser.getParent();
                    parent.repaint();
                } else {
                    Document doc = BrowserPane.this.browser.getDocument();
                    try {
                        BrowserPane.this.browser.setPage(this.url);
                    }
                    catch (IOException ioe) {
                        BrowserPane.this.browser.setDocument(doc);
                    }
                    finally {
                        this.url = null;
                        SwingUtilities.invokeLater(this);
                    }
                }
            }
        }
    }
}

