/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.Document;
import jp.co.argo21.commons.swing.BooleanDocument;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.DialogComponent;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;

public class AttributeComponent
extends DialogComponent {
    private static final String ATTRIBUTE_ICON = "attribute-mini";
    private static Icon attributeIcon;
    private static String[] columnNames;
    private static String[] typeNames;
    protected static final Border border;
    private JTable attrTable;
    private JTextField attrField;
    private JButton updateButton;
    private Document strDocument = new ByteLimitedDocument(128);
    private Document numDocument = new NumericDocument(9, true);
    private Document boolDocument = new BooleanDocument();
    private List attributes;
    private List updateAttributes;
    static /* synthetic */ Class class$jp$co$argo21$nautica$workflow$wfmc$Attribute;
    static /* synthetic */ Class class$java$lang$String;

    public AttributeComponent() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        this.updateAttributes = new ArrayList();
        JPanel panel = this.createEditorPanel(rm);
        this.addTab(rm.getResource("AttributeComponent.tab.0"), panel);
        this.validate();
    }

    private JPanel createEditorPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(border);
        Dimension size = new Dimension(500, 200);
        panel.setSize(size);
        panel.setPreferredSize(size);
        this.attrTable = new JTable(new AttributeTableModel());
        this.attrTable.setSelectionMode(0);
        this.attrTable.setRowHeight(20);
        this.attrTable.getColumnModel().getColumn(0).setCellRenderer(new AttributeCellRenderer());
        ListSelectionModel lsm = this.attrTable.getSelectionModel();
        lsm.addListSelectionListener(new SelectAttributeAction());
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.attrTable);
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BorderLayout());
        this.attrField = new JTextField();
        this.attrField.setDocument(this.strDocument);
        this.attrField.setEditable(false);
        this.updateButton = new JButton(rm.getResource("JButton.label.update"));
        this.updateButton.addActionListener(new UpdateAttributeAction());
        fieldPanel.add((Component)this.attrField, "Center");
        fieldPanel.add((Component)this.updateButton, "East");
        panel.add((Component)sp, "Center");
        panel.add((Component)fieldPanel, "South");
        this.validate();
        return panel;
    }

    public List getUpdatedAttributes() {
        return this.updateAttributes;
    }

    public void setAttributes(List attrs) {
        this.attributes = attrs;
    }

    public void init() {
    }

    public boolean commit() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        attributeIcon = IconManager.getIcon(ATTRIBUTE_ICON);
        columnNames = new String[3];
        AttributeComponent.columnNames[0] = rm.getResource("AttributeComponent.columnName.0");
        AttributeComponent.columnNames[1] = rm.getResource("AttributeComponent.columnName.1");
        AttributeComponent.columnNames[2] = rm.getResource("AttributeComponent.columnName.2");
        typeNames = new String[3];
        AttributeComponent.typeNames[0] = rm.getResource("AttributeComponent.typeName.0");
        AttributeComponent.typeNames[1] = rm.getResource("AttributeComponent.typeName.1");
        AttributeComponent.typeNames[2] = rm.getResource("AttributeComponent.typeName.2");
    }

    public class AttributeCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            Attribute attr = (Attribute)o;
            this.setText(attr.getName());
            if (attributeIcon != null) {
                this.setIcon(attributeIcon);
            }
            return this;
        }
    }

    class AttributeTableModel
    extends AbstractTableModel {
        AttributeTableModel() {
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            if (AttributeComponent.this.attributes == null) {
                return 0;
            }
            return AttributeComponent.this.attributes.size();
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            Attribute attr = (Attribute)AttributeComponent.this.attributes.get(row);
            if (col == 0) {
                return attr;
            }
            if (col == 1) {
                int type = attr.getType();
                if (type == 3) {
                    return typeNames[1];
                }
                if (type == 6) {
                    return typeNames[2];
                }
                return typeNames[0];
            }
            return attr.getValue();
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return class$jp$co$argo21$nautica$workflow$wfmc$Attribute == null ? (class$jp$co$argo21$nautica$workflow$wfmc$Attribute = AttributeComponent.class$("jp.co.argo21.nautica.workflow.wfmc.Attribute")) : class$jp$co$argo21$nautica$workflow$wfmc$Attribute;
            }
            return class$java$lang$String == null ? (class$java$lang$String = AttributeComponent.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class SelectAttributeAction
    implements ListSelectionListener {
        SelectAttributeAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selected = lsm.getMinSelectionIndex();
                Attribute attr = (Attribute)AttributeComponent.this.attributes.get(selected);
                String val = attr.getValue();
                int type = attr.getType();
                if (type == 3) {
                    AttributeComponent.this.attrField.setDocument(AttributeComponent.this.numDocument);
                    AttributeComponent.this.attrField.setHorizontalAlignment(4);
                } else if (type == 6) {
                    AttributeComponent.this.attrField.setDocument(AttributeComponent.this.boolDocument);
                    AttributeComponent.this.attrField.setHorizontalAlignment(2);
                } else {
                    AttributeComponent.this.attrField.setDocument(AttributeComponent.this.strDocument);
                    AttributeComponent.this.attrField.setHorizontalAlignment(2);
                }
                if (val == null) {
                    AttributeComponent.this.attrField.setText("");
                } else {
                    AttributeComponent.this.attrField.setText(val.trim());
                }
                AttributeComponent.this.attrField.setEditable(true);
            }
        }
    }

    class UpdateAttributeAction
    extends AbstractAction {
        UpdateAttributeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            int selected = AttributeComponent.this.attrTable.getSelectedRow();
            if (selected < 0) {
                DialogUtilities.showWarning(rm.getResource("W9001"));
                return;
            }
            Attribute attr = (Attribute)AttributeComponent.this.attributes.get(selected);
            attr.setValue(AttributeComponent.this.attrField.getText());
            if (AttributeComponent.this.updateAttributes.contains(attr)) {
                int ix = AttributeComponent.this.updateAttributes.indexOf(attr);
                AttributeComponent.this.updateAttributes.set(ix, attr);
            } else {
                AttributeComponent.this.updateAttributes.add(attr);
            }
            AttributeComponent.this.attrTable.clearSelection();
            AttributeComponent.this.attrField.setEditable(false);
            AttributeComponent.this.attrField.setText("");
            AttributeComponent.this.attrTable.updateUI();
        }
    }
}

