/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfadm.engineview.ConcurrentLayer;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;

public class ConcurrentLayerManager {
    private List subLayers = new ArrayList();
    private List activities = new ArrayList();

    public void initConcurrentLayer(List activities) {
        Hashtable<String, ConcurrentLayer> layers = new Hashtable<String, ConcurrentLayer>();
        Iterator it = activities.iterator();
        while (it.hasNext()) {
            ActivityDefinition act = (ActivityDefinition)it.next();
            if (!act.getType().equals("CONCUR_START")) continue;
            ConcurrentLayer l = new ConcurrentLayer();
            l.setStartDefinition(act);
            layers.put(act.getBlockID(), l);
        }
        Iterator it2 = activities.iterator();
        while (it2.hasNext()) {
            ActivityDefinition act = (ActivityDefinition)it2.next();
            if (act.getType().equals("CONCUR_START")) continue;
            if (act.getType().equals("CONCUR_END")) {
                ConcurrentLayer l = (ConcurrentLayer)layers.get(act.getBlockID());
                l.setEndDefinition(act);
                String parentID = act.getParentBID();
                if (StringUtils.checkNull(parentID)) {
                    this.addLayer(l);
                    continue;
                }
                ConcurrentLayer pl = (ConcurrentLayer)layers.get(parentID);
                l.setParentLayer(pl);
                pl.addLayer(l);
                continue;
            }
            String affID = act.getAffiliateBID();
            if (StringUtils.checkNull(affID)) continue;
            ConcurrentLayer al = (ConcurrentLayer)layers.get(affID);
            al.addLayerDefinition(act);
        }
    }

    public void addLayerDefinition(ActivityDefinition def) {
        if (def == null) {
            return;
        }
        this.activities.add(def);
    }

    public void addLayer(ConcurrentLayer layer) {
        if (layer == null) {
            return;
        }
        this.addLayerDefinition(layer.getStartDefinition());
        this.addLayerDefinition(layer.getEndDefinition());
        this.subLayers.add(layer);
    }

    public void paintLayerBackgroud(Graphics g, Color c, int grid) {
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ((ConcurrentLayer)it.next()).paintLayerBackgroud(g, c, grid);
        }
    }

    public void paintLayerBorder(Graphics g, Color c, int grid) {
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            ((ConcurrentLayer)it.next()).paintLayerBorder(g, c, grid);
        }
    }
}

