/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.common.FilteringDialogComponent;
import jp.co.argo21.nautica.workflow.filter.GroupFilter;
import jp.co.argo21.nautica.workflow.filter.NameFilter;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState;

public class ProcessDefinitionFilteringComponent
extends FilteringDialogComponent {
    private static String[] opeNames;
    private static String[] stateNames;
    protected static final Border border;
    private JTextField filterStringField;
    private JComboBox opeBox;
    private JComboBox stateBox;

    public ProcessDefinitionFilteringComponent() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        JPanel panel = this.createFilteringPanel(rm);
        this.addTab(rm.getResource("ProcessDefinitionFilteringComponent.tab.0"), panel);
        this.validate();
    }

    private JPanel createFilteringPanel(ResourceManager rm) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(border);
        Dimension size = new Dimension(370, 140);
        panel.setSize(size);
        panel.setPreferredSize(size);
        JLabel l0 = new JLabel(rm.getResource("ProcessDefinitionFilteringComponent.label.0"));
        JLabel l1 = new JLabel(rm.getResource("ProcessDefinitionFilteringComponent.label.1"));
        this.filterStringField = new JTextField();
        this.filterStringField.setDocument(new ByteLimitedDocument(64));
        this.opeBox = new JComboBox<String>(opeNames);
        this.stateBox = new JComboBox<String>(stateNames);
        panel.add(this.locate(l0, 10, 10, 150, 25));
        panel.add(this.locate(this.opeBox, 10, 40, 150, 25));
        panel.add(this.locate(this.filterStringField, 160, 40, 200, 25));
        panel.add(this.locate(l1, 10, 70, 150, 25));
        panel.add(this.locate(this.stateBox, 10, 100, 350, 25));
        this.validate();
        return panel;
    }

    public void init() {
        this.filterStringField.setText("");
        this.opeBox.setSelectedIndex(0);
        this.stateBox.setSelectedIndex(0);
    }

    public boolean commit() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        String s = this.filterStringField.getText();
        if (s == null) {
            return true;
        }
        if (s.trim().equals("")) {
            return true;
        }
        int ope = this.opeBox.getSelectedIndex();
        if (ope == 0) {
            return true;
        }
        String pat = "[^\\s\\\"\\']+";
        String msg = null;
        if (!Pattern.matches(pat, s)) {
            msg = rm.getResource("E9015");
        }
        return this.isValid(msg);
    }

    public Filter getFilter() {
        int op = this.opeBox.getSelectedIndex();
        int st = this.stateBox.getSelectedIndex();
        String s = this.filterStringField.getText();
        StateFilter nfilter = null;
        StateFilter sfilter = null;
        if (op != 0) {
            int comparison = 0;
            comparison = op == 2 ? 7 : 1;
            if (s != null && !s.trim().equals("")) {
                nfilter = new NameFilter(s, comparison);
            }
        }
        if (st == 1) {
            sfilter = new StateFilter((WfState)ProcessDefinitionState.ENABLE);
        } else if (st == 2) {
            sfilter = new StateFilter((WfState)ProcessDefinitionState.DISABLE);
        }
        StateFilter filter = null;
        if (nfilter != null && sfilter != null) {
            Filter[] filters = new Filter[]{nfilter, sfilter};
            filter = new GroupFilter(filters);
        } else if (nfilter != null) {
            filter = nfilter;
        } else if (sfilter != null) {
            filter = sfilter;
        } else {
            Filter[] filters = new Filter[]{};
            filter = new GroupFilter(filters);
        }
        return filter;
    }

    private boolean isValid(String msg) {
        if (msg != null) {
            DialogUtilities.showError(msg);
            return false;
        }
        return true;
    }

    static {
        border = BorderFactory.createEtchedBorder();
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        opeNames = new String[3];
        ProcessDefinitionFilteringComponent.opeNames[0] = rm.getResource("ProcessDefinitionFilteringComponent.opeName.0");
        ProcessDefinitionFilteringComponent.opeNames[1] = rm.getResource("ProcessDefinitionFilteringComponent.opeName.1");
        ProcessDefinitionFilteringComponent.opeNames[2] = rm.getResource("ProcessDefinitionFilteringComponent.opeName.2");
        stateNames = new String[3];
        ProcessDefinitionFilteringComponent.stateNames[0] = rm.getResource("ProcessDefinitionFilteringComponent.stateName.0");
        ProcessDefinitionFilteringComponent.stateNames[1] = rm.getResource("ProcessDefinitionFilteringComponent.stateName.1");
        ProcessDefinitionFilteringComponent.stateNames[2] = rm.getResource("ProcessDefinitionFilteringComponent.stateName.2");
    }
}

