/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.engineview.ActivityDefinitionPropertyDialog;
import jp.co.argo21.nautica.tool.wfadm.engineview.EngineViewFrame;
import jp.co.argo21.nautica.tool.wfadm.engineview.ProcessDefinitionFlowView;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;

public class ProcessDefinitionFlowPanel
extends JPanel {
    private JToolBar toolbar;
    private EngineViewFrame frame;
    private ProcessDefinitionFlowView view;
    private ProcDef procDef;
    private PackageDefinition packageDefinition;

    public ProcessDefinitionFlowPanel(EngineViewFrame frame, ProcDef pd, PackageDefinition def) {
        super(new BorderLayout(), true);
        this.frame = frame;
        this.procDef = pd;
        this.packageDefinition = def;
        this.createFlowView();
        this.createToolBar();
    }

    String getProcessDefinitionName() {
        return this.procDef.getID();
    }

    private void createToolBar() {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        this.toolbar = new JToolBar(1);
        this.toolbar.setFloatable(false);
        Icon icon = IconManager.getIcon("property");
        JButton propButton = new JButton();
        propButton.setIcon(icon);
        propButton.setToolTipText(rm.getResource("ProcessDefinitionFlowPanel.toolbar.label.0"));
        propButton.addActionListener(new ShowPropertyAction());
        this.toolbar.add(propButton);
        this.add((Component)this.toolbar, "West");
    }

    private void createFlowView() {
        int index = this.getProcessDefinitionIndex();
        List procs = this.packageDefinition.getProcesses();
        ProcessDefinition def = (ProcessDefinition)procs.get(index);
        this.view = new ProcessDefinitionFlowView(def);
        JScrollPane sp = new JScrollPane(this.view);
        this.add((Component)sp, "Center");
    }

    private Properties getProperties(ResourceManager rm, ActivityDefinition act) {
        Properties prop = new Properties();
        prop.put(rm.getResource("ActivityDefinition.key.0"), "" + act.getAffiliateBID());
        prop.put(rm.getResource("ActivityDefinition.key.1"), "" + act.getApplicationID());
        prop.put(rm.getResource("ActivityDefinition.key.2"), "" + act.getBlockID());
        prop.put(rm.getResource("ActivityDefinition.key.3"), "" + act.getDescription());
        prop.put(rm.getResource("ActivityDefinition.key.4"), "" + act.getEngineName());
        prop.put(rm.getResource("ActivityDefinition.key.5"), "" + act.getID());
        prop.put(rm.getResource("ActivityDefinition.key.6"), "" + act.getName());
        prop.put(rm.getResource("ActivityDefinition.key.7"), "" + act.getParentBID());
        prop.put(rm.getResource("ActivityDefinition.key.8"), "" + act.getPerformerID());
        prop.put(rm.getResource("ActivityDefinition.key.9"), "" + act.getSubprocessID());
        prop.put(rm.getResource("ActivityDefinition.key.10"), "" + act.getType());
        prop.put(rm.getResource("ActivityDefinition.key.11"), "" + act.getExecution());
        prop.put(rm.getResource("ActivityDefinition.key.12"), "" + act.getLimit());
        prop.put(rm.getResource("ActivityDefinition.key.13"), "" + act.getLogicalX());
        prop.put(rm.getResource("ActivityDefinition.key.14"), "" + act.getLogicalY());
        return prop;
    }

    private int getProcessDefinitionIndex() {
        String pdid = this.procDef.getID();
        int begin = pdid.lastIndexOf(45) + 1;
        int end = pdid.length();
        String indexString = pdid.substring(begin, end);
        int index = Integer.parseInt(indexString);
        return index;
    }

    private List getTransitions(ActivityDefinition act) {
        ArrayList<TransitionDefinition> trs = new ArrayList<TransitionDefinition>();
        if (act == null) {
            return trs;
        }
        int index = this.getProcessDefinitionIndex();
        List procs = this.packageDefinition.getProcesses();
        ProcessDefinition proc = (ProcessDefinition)procs.get(index);
        Iterator tit = proc.getTransitions().iterator();
        while (tit.hasNext()) {
            TransitionDefinition t = (TransitionDefinition)tit.next();
            if (act != t.getSource()) continue;
            trs.add(t);
        }
        return trs;
    }

    private class ShowPropertyAction
    implements ActionListener {
        private ShowPropertyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ProcessDefinitionFlowPanel.this.view == null) {
                return;
            }
            ResourceManager rm = WorkflowAdminManager.getResourceManager();
            ActivityDefinition act = ProcessDefinitionFlowPanel.this.view.getSelectedActivity();
            if (act == null) {
                DialogUtilities.showError(rm.getResource("E9018"));
                return;
            }
            Properties prop = ProcessDefinitionFlowPanel.this.getProperties(rm, act);
            List trs = ProcessDefinitionFlowPanel.this.getTransitions(act);
            List vars = ProcessDefinitionFlowPanel.this.packageDefinition.getVariables();
            ActivityDefinitionPropertyDialog.showDialog(ProcessDefinitionFlowPanel.this, act.getName(), prop, trs, vars);
        }
    }
}

