/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.tool.wfadm.engineview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import jp.co.argo21.commons.swing.Grid;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfadm.IconManager;
import jp.co.argo21.nautica.tool.wfadm.WorkflowAdminManager;
import jp.co.argo21.nautica.tool.wfadm.engineview.ConcurrentLayerManager;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;

public class ProcessDefinitionFlowView
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static final int GRID_SIZE = 80;
    private static final int MAX_ICON_SIZE = 48;
    private static final int INSET_SIZE = 9;
    private static final int MIN_LOGICAL_WIDTH = 10;
    private static final int MIN_LOGICAL_HEIGHT = 10;
    private static final Color BACKGROUND = new Color(255, 255, 230);
    private static final Color LAYER_BACKGROUND = new Color(230, 255, 255, 64);
    private static final Font VIEW_FONT = new Font("MonoSpaced", 0, 10);
    private static GeneralPath ARROW_PATH = new GeneralPath(0);
    private Rectangle cursorRect;
    private Rectangle selectedRect;
    private ProcessDefinition proc;
    private ActivityDefinition selectedActivity;
    private ConcurrentLayerManager root;

    public ProcessDefinitionFlowView(ProcessDefinition proc) {
        this.proc = proc;
        int w = proc.getLogicalWidth();
        int h = proc.getLogicalHeight();
        if (w < 10) {
            w = 10;
        }
        if (h < 10) {
            h = 10;
        }
        Dimension size = new Dimension(80 * w + 1, 80 * h + 1);
        this.root = new ConcurrentLayerManager();
        this.root.initConcurrentLayer(proc.getActivities());
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        Shape clip = g.getClip();
        Dimension size = this.getSize();
        g.setColor(Color.gray);
        g.fillRect(0, 0, size.width, size.height);
        Dimension psize = this.getPreferredSize();
        g.setColor(BACKGROUND);
        g.fillRect(0, 0, psize.width, psize.height);
        this.root.paintLayerBackgroud(g, LAYER_BACKGROUND, 80);
        if (this.selectedActivity != null) {
            this.paintActivityBackground(g, Color.pink, this.selectedActivity);
        }
        this.paintView(g);
        if (this.cursorRect != null) {
            g.drawRect(this.cursorRect.x, this.cursorRect.y, this.cursorRect.width, this.cursorRect.height);
        }
        this.root.paintLayerBorder(g, Color.blue, 80);
        if (this.selectedRect != null) {
            g.setColor(Color.red);
            g.drawRect(this.selectedRect.x, this.selectedRect.y, this.selectedRect.width, this.selectedRect.height);
        }
        g.setClip(clip);
        g.dispose();
    }

    public void paintView(Graphics g) {
        Shape clip = g.getClip();
        g.setFont(VIEW_FONT);
        Dimension psize = this.getPreferredSize();
        Grid.draw(new Rectangle(psize), g, 80);
        g.clipRect(0, 0, psize.width, psize.height);
        g.setColor(Color.black);
        List acts = this.proc.getActivities();
        Iterator ait = acts.iterator();
        while (ait.hasNext()) {
            ActivityDefinition act = (ActivityDefinition)ait.next();
            this.paintActivity(g, act);
        }
        List trs = this.proc.getTransitions();
        Iterator tit = trs.iterator();
        while (tit.hasNext()) {
            TransitionDefinition tr = (TransitionDefinition)tit.next();
            this.paintTransition(g, Color.black, tr.getSource(), tr.getDestination());
        }
        g.setClip(clip);
    }

    private void paintActivityBackground(Graphics g, Color c, ActivityDefinition act) {
        if (act == null) {
            return;
        }
        int ax = act.getLogicalX();
        int ay = act.getLogicalY();
        int x = 80 * ax;
        int y = 80 * ay;
        int w = 80;
        int h = 80;
        g.setColor(c);
        g.fillRect(x, y, w, h);
    }

    private void paintActivity(Graphics g, ActivityDefinition act) {
        ResourceManager rm = WorkflowAdminManager.getResourceManager();
        String name = act.getName();
        if (StringUtils.checkNull(name)) {
            name = rm.getResource("ProcessDefinitionFlowView.noname");
        }
        String type = act.getType();
        String iconName = this.getIconName(type);
        Icon icon = IconManager.getIcon(iconName);
        int ax = act.getLogicalX();
        int ay = act.getLogicalY();
        int x = 80 * ax;
        int y = 80 * ay;
        int w = 80;
        int h = 80;
        int iconW = icon.getIconWidth();
        int iconH = icon.getIconHeight();
        int iconX = x + (w - iconW) / 2;
        int iconY = y + 9;
        icon.paintIcon(this, g, iconX, iconY);
        FontMetrics metrics = g.getFontMetrics();
        int fontH = metrics.getHeight();
        int descent = metrics.getDescent();
        int lineW = metrics.stringWidth(name);
        int dx = x + (w - lineW) / 2;
        int dy = y + 9 + iconH;
        if (dx < 0) {
            dx = 0;
        }
        dy = dy + fontH - descent;
        g.setColor(SystemColor.textText);
        g.drawString(name, dx, dy);
    }

    private void paintTransition(Graphics g, Color c, ActivityDefinition src, ActivityDefinition dst) {
        if (src == null) {
            return;
        }
        if (dst == null) {
            return;
        }
        int sx = src.getLogicalX();
        int sy = src.getLogicalY();
        int dx = dst.getLogicalX();
        int dy = dst.getLogicalY();
        Point sp = this.getSourcePoint(sx, sy, dx, dy);
        Point dp = this.getDestinationPoint(sx, sy, dx, dy);
        this.paintArrowLine(g, c, sp.x, sp.y, dp.x, dp.y);
    }

    private void paintArrowLine(Graphics g, Color c, int sx, int sy, int dx, int dy) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        g2.setColor(c);
        g2.drawLine(sx, sy, dx, dy);
        g2.translate(dx, dy);
        double theta = Math.atan2(sy - dy, sx - dx);
        g2.rotate(theta);
        g2.fill(ARROW_PATH);
        g2.draw(ARROW_PATH);
        g2.setTransform(tr);
    }

    private Point getSourcePoint(int sx, int sy, int dx, int dy) {
        int x = sx * 80 + 40;
        int y = sy * 80 + 40;
        if (sx < dx) {
            x = sx * 80 + 64;
            y = sy * 80 + 9 + 24;
        } else if (sx > dx) {
            x = sx * 80 + 16;
            y = sy * 80 + 9 + 24;
        } else if (sy < dy) {
            y = sy * 80 + 80 - 9;
        } else if (sy > dy) {
            y = sy * 80 + 9;
        }
        return new Point(x, y);
    }

    private Point getDestinationPoint(int sx, int sy, int dx, int dy) {
        int x = dx * 80 + 40;
        int y = dy * 80 + 40;
        if (sx < dx) {
            x = dx * 80 + 16;
            y = dy * 80 + 9 + 24;
        } else if (sx > dx) {
            x = dx * 80 + 64;
            y = dy * 80 + 9 + 24;
        } else if (sy < dy) {
            y = dy * 80 + 9;
        } else if (sy > dy) {
            y = dy * 80 + 80 - 9;
        }
        return new Point(x, y);
    }

    private ActivityDefinition getActivity(int mx, int my) {
        int lx = mx / 80;
        int ly = my / 80;
        List acts = this.proc.getActivities();
        Iterator it = acts.iterator();
        while (it.hasNext()) {
            ActivityDefinition act = (ActivityDefinition)it.next();
            int x = act.getLogicalX();
            int y = act.getLogicalY();
            if (x != lx || y != ly) continue;
            return act;
        }
        return null;
    }

    public void setSelectedActivity(ActivityDefinition act) {
        this.selectedActivity = act;
    }

    private String getIconName(String type) {
        String iconName = null;
        if (type.equals("START")) {
            iconName = "start";
        } else if (type.equals("INTERACTIVE")) {
            iconName = "interactive";
        } else if (type.equals("AUTOMATIC")) {
            iconName = "automatic";
        } else if (type.equals("SUBPROCESS")) {
            iconName = "subprocess";
        } else if (type.equals("CONCUR_START")) {
            iconName = "concurrent-start";
        } else if (type.equals("CONCUR_END")) {
            iconName = "concurrent-end";
        } else if (type.equals("END")) {
            iconName = "end";
        }
        return iconName;
    }

    public ActivityDefinition getSelectedActivity() {
        return this.selectedActivity;
    }

    public void mouseClicked(MouseEvent e) {
        int mx = e.getX();
        int my = e.getY();
        int lx = mx / 80;
        int ly = my / 80;
        if (this.selectedRect == null) {
            this.selectedRect = new Rectangle(80, 80);
        }
        this.selectedRect.x = lx * 80;
        this.selectedRect.y = ly * 80;
        this.setSelectedActivity(this.getActivity(mx, my));
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.cursorRect = null;
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        int mx = e.getX();
        int my = e.getY();
        Dimension psize = this.getPreferredSize();
        if (mx >= psize.width || my >= psize.height) {
            this.cursorRect = null;
            this.repaint();
            return;
        }
        int lx = mx / 80;
        int ly = my / 80;
        if (this.cursorRect == null) {
            this.cursorRect = new Rectangle(80, 80);
        }
        this.cursorRect.x = lx * 80;
        this.cursorRect.y = ly * 80;
        this.repaint();
    }

    static {
        ARROW_PATH.moveTo(0.0f, 0.0f);
        ARROW_PATH.lineTo(15.0f, 5.0f);
        ARROW_PATH.lineTo(15.0f, -5.0f);
        ARROW_PATH.closePath();
    }
}

