/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.util.Hashtable;
import java.util.Map;
import jp.co.argo21.nautica.workflow.engine.ActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.AutomaticActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.ConcurrentEndActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.ConcurrentStartActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.EndActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.InteractiveActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.StartActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.SubprocessActivityBehavior;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

class ActivityBehaviorFactory {
    private static Logger eLog = LogManager.getEngineLogger();
    private static ActivityBehaviorFactory singleton;
    private Map activityBehaviors = new Hashtable();

    static void create() throws Exception {
        singleton = new ActivityBehaviorFactory();
        try {
            singleton.init();
        }
        catch (Exception ex) {
            String msg = StringManager.get("E0051");
            eLog.error((Object)msg);
            throw new WorkflowException(msg);
        }
    }

    static ActivityBehaviorFactory getInstance() {
        return singleton;
    }

    private ActivityBehaviorFactory() {
    }

    private void init() throws Exception {
        this.activityBehaviors.put("START", new StartActivityBehavior());
        this.activityBehaviors.put("INTERACTIVE", new InteractiveActivityBehavior());
        this.activityBehaviors.put("AUTOMATIC", new AutomaticActivityBehavior());
        this.activityBehaviors.put("SUBPROCESS", new SubprocessActivityBehavior());
        this.activityBehaviors.put("CONCUR_START", new ConcurrentStartActivityBehavior());
        this.activityBehaviors.put("CONCUR_END", new ConcurrentEndActivityBehavior());
        this.activityBehaviors.put("END", new EndActivityBehavior());
    }

    public ActivityBehavior getActivityBehavior(String type) {
        return (ActivityBehavior)this.activityBehaviors.get(type);
    }
}

