/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionBean;
import jp.co.argo21.nautica.workflow.dataaccess.AppExecutionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ApplicationDefinition;
import jp.co.argo21.nautica.workflow.definition.ParticipantDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.engine.AbstractActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.ActivityInternal;
import jp.co.argo21.nautica.workflow.engine.ConditionEvaluator;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.StartActivityRequestMessage;
import jp.co.argo21.nautica.workflow.engine.SystemMessageTransporter;
import jp.co.argo21.nautica.workflow.engine.ToolAgentManager;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.ToolAgent;

public class AutomaticActivityBehavior
extends AbstractActivityBehavior {
    public void abort(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act, boolean checkChild) throws Exception {
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        String aid = abean.getActivityID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        WorkItemDAO wiDAO = daoFactory.getWorkItemDAO();
        WorkItemBean wibean = wiDAO.findByProcessIDANDActivityID(pid, aid);
        String wid = wibean.getID();
        AppExecutionDAO aeDAO = daoFactory.getAppExecutionDAO();
        List aebeans = aeDAO.findByStarterID(wid);
        Iterator aeit = aebeans.iterator();
        while (aeit.hasNext()) {
            AppExecutionBean aebean = (AppExecutionBean)aeit.next();
            String appName = aebean.getAppName();
            int handle = aebean.getExecId();
            ToolAgentManager tam = ToolAgentManager.getInstance();
            ToolAgent agent = tam.getToolAgent(appName);
            try {
                agent.terminateApplication(handle, wid);
            }
            catch (Exception ex) {
                String msg = StringManager.get("W0002");
                eLog.warn((Object)msg, (Throwable)ex);
            }
        }
        wiDAO.deleteByProcessIDANDActivityID(pid, aid);
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.CLOSED_ABORTED, ts);
    }

    public void start(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act) throws Exception {
        ProcessBean pbean = proc.getBean();
        String pdid = pbean.getProcDefinitionID();
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        String aid = abean.getActivityID();
        String performerID = ad.getPerformerID();
        String appID = ad.getApplicationID();
        List aparams = ad.getApplicationParameters();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        DefinitionDAO defDAO = daoFactory.getDefinitionDAO();
        DefinitionBean defbean = defDAO.findByPrimaryKey(pdid);
        String defID = defbean.getProcessDefinitionID();
        ParticipantDefinition partd = this.getParticipantDefinition(defID, performerID);
        if (partd == null) {
            act.terminate();
            String msg = StringManager.get("F0002");
            eLog.fatal((Object)msg);
            throw new WorkflowException(msg);
        }
        ApplicationDefinition appd = this.getApplicationDefinition(defID, appID);
        if (appd == null) {
            act.terminate();
            String msg = StringManager.get("F0003");
            eLog.fatal((Object)msg);
            throw new WorkflowException(msg);
        }
        Iterator apit = aparams.iterator();
        Attribute[] attrs = new Attribute[aparams.size()];
        int i = 0;
        while (apit.hasNext()) {
            String varID = (String)apit.next();
            VariableDAO varDAO = daoFactory.getVariableDAO();
            VariableBean vbean = varDAO.findByDefinitionID(pid, varID);
            attrs[i] = vbean;
            ++i;
        }
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);
        WorkItemBean wbean = new WorkItemBean();
        wbean.setID(UniqueKeyGenerator.generate("WII"));
        wbean.setProcessID(pid);
        wbean.setActivityID(aid);
        wbean.setParticipantName(partd.getName());
        wbean.setParticipantType(partd.getType());
        WorkItemDAO workDAO = daoFactory.getWorkItemDAO();
        workDAO.insert(wbean);
        String appName = appd.getName();
        ToolAgentManager tam = ToolAgentManager.getInstance();
        ToolAgent agent = tam.getToolAgent(appName);
        try {
            int tahandle = agent.invokeApplication(appName, wbean.getID(), attrs);
        }
        catch (Exception ex) {
            String E0104 = StringManager.get("E0104") + "(app name = " + appName + ")";
            eLog.fatal((Object)E0104, (Throwable)ex);
            act.terminate();
        }
    }

    public void terminate(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act, boolean checkChild) throws Exception {
        ProcessBean pbean = proc.getBean();
        String pid = pbean.getID();
        ActivityBean abean = act.getBean();
        String aid = abean.getActivityID();
        String bid = abean.getBlockID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        WorkItemDAO wiDAO = daoFactory.getWorkItemDAO();
        WorkItemBean wibean = wiDAO.findByProcessIDANDActivityID(pid, aid);
        String wid = wibean.getID();
        AppExecutionDAO aeDAO = daoFactory.getAppExecutionDAO();
        List aebeans = aeDAO.findByStarterID(wid);
        Iterator aeit = aebeans.iterator();
        while (aeit.hasNext()) {
            AppExecutionBean aebean = (AppExecutionBean)aeit.next();
            String appName = aebean.getAppName();
            int handle = aebean.getExecId();
            ToolAgentManager tam = ToolAgentManager.getInstance();
            ToolAgent agent = tam.getToolAgent(appName);
            try {
                agent.terminateApplication(handle, wid);
            }
            catch (Exception ex) {
                String msg = StringManager.get("W0002");
                eLog.warn((Object)msg, (Throwable)ex);
            }
        }
        wiDAO.deleteByProcessIDANDActivityID(pid, aid);
        VariableDAO varDAO = daoFactory.getVariableDAO();
        List vars = varDAO.findByProcessIDAsList(pid);
        List trs = ConditionEvaluator.evaluate(pd, ad, vars, true);
        Iterator it = trs.iterator();
        ArrayList<ActivityBean> acts = new ArrayList<ActivityBean>();
        while (it.hasNext()) {
            TransitionDefinition tr = (TransitionDefinition)it.next();
            ActivityDefinition dest = tr.getDestination();
            ActivityBean ab = this.createActivity(pd, dest, pbean, bid);
            acts.add(ab);
        }
        if (acts.size() == 0) {
            this.suspend(pd, ad, proc, act);
            String msg = StringManager.get("F0001");
            eLog.fatal((Object)msg);
            return;
        }
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.CLOSED_TERMINATED, ts);
        Iterator ait = acts.iterator();
        while (ait.hasNext()) {
            ActivityBean ab = (ActivityBean)ait.next();
            WorkflowEngine engine = WorkflowEngine.getInstance();
            String abid = ab.getActivityID();
            StartActivityRequestMessage sarmsg = new StartActivityRequestMessage(pid, abid);
            SystemMessageTransporter mt = new SystemMessageTransporter("START_ACTIVITY_REQUEST");
            mt.sendMessage(sarmsg);
        }
    }
}

