/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;
import org.apache.log4j.Logger;

public class ResourceManagerFactory {
    private static Logger eLog = LogManager.getEngineLogger();
    private static Logger sLog = LogManager.getSercurityLogger();
    private static ResourceManagerFactory singleton;
    private UserManager userManager;
    private OrganizationManager orgManager;
    private RoleManager roleManager;

    static void create() throws Exception {
        singleton = new ResourceManagerFactory();
        try {
            singleton.init();
        }
        catch (Exception ex) {
            eLog.error((Object)StringManager.get("E1005"));
            throw ex;
        }
    }

    static ResourceManagerFactory getInstance() {
        return singleton;
    }

    private ResourceManagerFactory() {
    }

    private void init() throws Exception {
        String umcn = System.getProperty("nautica.workflow.userManager");
        if (umcn == null || umcn.trim().equals("")) {
            String E1002 = StringManager.get("E1002");
            sLog.error((Object)E1002);
            throw new WorkflowException(E1002);
        }
        this.userManager = (UserManager)Class.forName(umcn).newInstance();
        String I1002 = StringManager.get("I1002");
        eLog.info((Object)I1002);
        String omcn = System.getProperty("nautica.workflow.organizationManager");
        if (omcn == null || omcn.trim().equals("")) {
            String E1003 = StringManager.get("E1003");
            sLog.error((Object)E1003);
            throw new WorkflowException(E1003);
        }
        this.orgManager = (OrganizationManager)Class.forName(omcn).newInstance();
        String I1003 = StringManager.get("I1003");
        eLog.info((Object)I1003);
        String rmcn = System.getProperty("nautica.workflow.roleManager");
        if (rmcn == null || rmcn.trim().equals("")) {
            String E1004 = StringManager.get("E1004");
            sLog.error((Object)E1004);
            throw new WorkflowException(E1004);
        }
        this.roleManager = (RoleManager)Class.forName(rmcn).newInstance();
        String I1004 = StringManager.get("I1004");
        eLog.info((Object)I1004);
    }

    public UserManager getUserManager(String session) throws WorkflowSecurityException {
        return this.userManager;
    }

    public OrganizationManager getOrganizationManager(String session) throws WorkflowSecurityException {
        return this.orgManager;
    }

    public RoleManager getRoleManager(String session) throws WorkflowSecurityException {
        return this.roleManager;
    }

    UserManager getUserManager() throws WorkflowSecurityException {
        return this.userManager;
    }

    OrganizationManager getOrganizationManager() throws WorkflowSecurityException {
        return this.orgManager;
    }

    RoleManager getRoleManager() throws WorkflowSecurityException {
        return this.roleManager;
    }
}

