/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessWaitActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.TargetProcessDAO;
import jp.co.argo21.nautica.workflow.dataaccess.VariableBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.engine.AbstractActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.ActivityInternal;
import jp.co.argo21.nautica.workflow.engine.ConditionEvaluator;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.EndProcessRequestMessage;
import jp.co.argo21.nautica.workflow.engine.InterWorkflowConnectorImpl;
import jp.co.argo21.nautica.workflow.engine.ParticipantImpl;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.engine.RequesterManager;
import jp.co.argo21.nautica.workflow.engine.StartActivityRequestMessage;
import jp.co.argo21.nautica.workflow.engine.StartProcessRequestMessage;
import jp.co.argo21.nautica.workflow.engine.SystemMessageTransporter;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.omg.WfRequester;
import jp.co.argo21.nautica.workflow.rmi.InterWorkflowConnectorRemote;
import jp.co.argo21.nautica.workflow.util.StateHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.ProcessState;

public class SubprocessActivityBehavior
extends AbstractActivityBehavior {
    public void abort(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act, boolean checkChild) throws Exception {
        String scope = System.getProperty("nautica.workflow.scope");
        if (scope == null) {
            scope = "";
        }
        scope = scope.trim();
        String engineName = ad.getEngineName();
        if (engineName == null || engineName.trim().equals("") || engineName.trim().equals(scope)) {
            this.terminateOrAbortOnLocalEngine(pd, ad, proc, act, ProcessState.CLOSED_ABORTED);
        } else {
            this.terminateOrAbortOnRemoteEngine(pd, ad, proc, act, ProcessState.CLOSED_ABORTED);
        }
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.CLOSED_ABORTED, ts);
    }

    public void start(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act) throws Exception {
        try {
            String scope = System.getProperty("nautica.workflow.scope");
            if (scope == null) {
                scope = "";
            }
            scope = scope.trim();
            String engineName = ad.getEngineName();
            if (engineName == null || engineName.trim().equals("") || engineName.trim().equals(scope)) {
                this.startOnLocalEngine(pd, ad, proc, act);
            } else {
                this.startOnRemoteEngine(pd, ad, proc, act);
            }
        }
        catch (Exception ex) {
            String E0160 = StringManager.get("E0160");
            eLog.fatal((Object)E0160, (Throwable)ex);
            act.terminate();
        }
    }

    public void terminate(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act, boolean checkChild) throws Exception {
        ProcessBean pbean = proc.getBean();
        String pid = pbean.getID();
        ActivityBean abean = act.getBean();
        String aid = abean.getActivityID();
        String bid = abean.getBlockID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        if (checkChild) {
            String scope = System.getProperty("nautica.workflow.scope");
            if (scope == null) {
                scope = "";
            }
            scope = scope.trim();
            String engineName = ad.getEngineName();
            if (engineName == null || engineName.trim().equals("") || engineName.trim().equals(scope)) {
                this.terminateOrAbortOnLocalEngine(pd, ad, proc, act, ProcessState.CLOSED_TERMINATED);
            } else {
                this.terminateOrAbortOnRemoteEngine(pd, ad, proc, act, ProcessState.CLOSED_TERMINATED);
            }
        }
        VariableDAO varDAO = daoFactory.getVariableDAO();
        List vars = varDAO.findByProcessIDAsList(pid);
        List trs = ConditionEvaluator.evaluate(pd, ad, vars, true);
        Iterator it = trs.iterator();
        ArrayList<ActivityBean> acts = new ArrayList<ActivityBean>();
        while (it.hasNext()) {
            TransitionDefinition tr = (TransitionDefinition)it.next();
            ActivityDefinition dest = tr.getDestination();
            ActivityBean ab = this.createActivity(pd, dest, pbean, bid);
            acts.add(ab);
        }
        if (acts.size() == 0) {
            this.suspend(pd, ad, proc, act);
            String msg = StringManager.get("F0001");
            eLog.fatal((Object)msg);
            return;
        }
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.CLOSED_TERMINATED, ts);
        Iterator ait = acts.iterator();
        while (ait.hasNext()) {
            ActivityBean ab = (ActivityBean)ait.next();
            WorkflowEngine engine = WorkflowEngine.getInstance();
            String abid = ab.getActivityID();
            StartActivityRequestMessage sarmsg = new StartActivityRequestMessage(pid, abid);
            SystemMessageTransporter mt = new SystemMessageTransporter("START_ACTIVITY_REQUEST");
            mt.sendMessage(sarmsg);
        }
    }

    private void startOnLocalEngine(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act) throws Exception {
        ProcessBean pbean = proc.getBean();
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        String aid = abean.getActivityID();
        String spdid = ad.getSubprocessID();
        List sparams = ad.getSubprocessParameters();
        int exec = ad.getExecution();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);
        String pdid = pbean.getProcDefinitionID();
        DefinitionDAO defDAO = daoFactory.getDefinitionDAO();
        DefinitionBean defbean = defDAO.findByPrimaryKey(pdid);
        String path = defbean.getPath();
        DefinitionBean subdefbean = defDAO.findByPathAndID(path, spdid);
        String subdefname = subdefbean.getProcessDefinitionID();
        ProcessInternal sprocess = null;
        Participant system = ParticipantImpl.getSystemParticipant();
        RequesterManager rqm = RequesterManager.getInstance();
        WfRequester requester = rqm.getRequesterByUserID(system.getID());
        ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
        ProcessManager pm = pmf.getProcessManager(subdefname);
        sprocess = (ProcessInternal)pm.createProcess(requester, system.getName());
        ProcessBean spb = sprocess.getBean();
        String spid = spb.getID();
        Iterator spit = sparams.iterator();
        int i = 0;
        while (spit.hasNext()) {
            String varID = (String)spit.next();
            VariableDAO varDAO = daoFactory.getVariableDAO();
            VariableBean svbean = varDAO.findByDefinitionID(pid, varID);
            VariableBean dvbean = varDAO.findByDefinitionID(spid, varID);
            String val = svbean.getValue();
            varDAO.update(dvbean, val, aid, DataAccessManager.getAccessTime());
            ++i;
        }
        if (exec == 2) {
            ProcessWaitActivityDAO pwDAO = daoFactory.getProcessWaitActivityDAO();
            ProcessWaitActivityBean pwbean = new ProcessWaitActivityBean();
            pwbean.setProcID(pid);
            pwbean.setActID(aid);
            pwbean.setSubprocID(spid);
            pwDAO.insert(pwbean);
        }
        StartProcessRequestMessage msg = new StartProcessRequestMessage(spb.getID());
        WorkflowEngine engine = WorkflowEngine.getInstance();
        SystemMessageTransporter mt = new SystemMessageTransporter("START_PROCESS_REQUEST");
        mt.sendMessage(msg);
        if (exec == 1) {
            act.complete();
        }
    }

    private void startOnRemoteEngine(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act) throws Exception {
        String engineName = ad.getEngineName();
        ProcessBean pbean = proc.getBean();
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        String aid = abean.getActivityID();
        String spdid = ad.getSubprocessID();
        List sparams = ad.getSubprocessParameters();
        int exec = ad.getExecution();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);
        String pdid = pbean.getProcDefinitionID();
        DefinitionDAO defDAO = daoFactory.getDefinitionDAO();
        DefinitionBean defbean = defDAO.findByPrimaryKey(pdid);
        String path = defbean.getPath();
        DefinitionBean subdefbean = defDAO.findByPathAndID(path, spdid);
        String subdefname = subdefbean.getProcessDefinitionID();
        InterWorkflowConnectorRemote iwc = InterWorkflowConnectorImpl.getRemoteInstance(engineName);
        String eid = InterWorkflowConnectorImpl.connectToRemoteEngine(iwc);
        int flag = 0;
        if (exec == 2) {
            flag = 1;
        }
        String userid = "__SYSTEM__";
        String roleid = "REMOTE_ENGINE";
        String spid = iwc.createProcess(eid, subdefname, flag, pid, aid, userid, roleid);
        Attribute[] attrs = new Attribute[sparams.size()];
        Iterator spit = sparams.iterator();
        int i = 0;
        while (spit.hasNext()) {
            String varID = (String)spit.next();
            VariableDAO varDAO = daoFactory.getVariableDAO();
            VariableBean vbean = varDAO.findByDefinitionID(pid, varID);
            attrs[i] = vbean;
            ++i;
        }
        iwc.setProcessAttributes(eid, pid, aid, spid, attrs);
        if (flag == 1) {
            TargetProcessDAO tpDAO = daoFactory.getTargetProcessDAO();
            TargetProcessBean tpbean = new TargetProcessBean();
            tpbean.setEngineID(engineName);
            tpbean.setRootProcID(pid);
            tpbean.setRootActID(aid);
            tpbean.setProcessID(spid);
            tpDAO.insert(tpbean);
        }
        iwc.disconnect(eid);
        StartProcessRequestMessage msg = new StartProcessRequestMessage(engineName, spid);
        WorkflowEngine engine = WorkflowEngine.getInstance();
        SystemMessageTransporter mt = new SystemMessageTransporter("START_PROCESS_REQUEST");
        mt.sendMessage(msg);
        if (flag == 0) {
            act.complete();
        }
    }

    private void terminateOrAbortOnLocalEngine(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act, ProcessState state) throws Exception {
        ProcessBean pbean = proc.getBean();
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        String aid = abean.getActivityID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        ProcessWaitActivityDAO pwDAO = daoFactory.getProcessWaitActivityDAO();
        ProcessWaitActivityBean pwabean = pwDAO.findByProcIDANDActID(pid, aid);
        if (pwabean != null) {
            String spid = pwabean.getSubprocID();
            WorkflowEngine engine = WorkflowEngine.getInstance();
            EndProcessRequestMessage eprmsg = new EndProcessRequestMessage(spid, ActivityState.CLOSED_ABORTED);
            SystemMessageTransporter mt = new SystemMessageTransporter("END_PROCESS_REQUEST");
            mt.sendMessage(eprmsg);
        }
    }

    private void terminateOrAbortOnRemoteEngine(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act, ProcessState state) throws Exception {
        String engineName = ad.getEngineName();
        ProcessBean pbean = proc.getBean();
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        String aid = abean.getActivityID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        TargetProcessDAO tpDAO = daoFactory.getTargetProcessDAO();
        TargetProcessBean tpbean = tpDAO.findByRootID(pid, aid);
        if (tpbean != null) {
            String spid = tpbean.getProcessID();
            WorkflowEngine engine = WorkflowEngine.getInstance();
            ActivityState astate = StateHelper.convert(state);
            EndProcessRequestMessage eprmsg = new EndProcessRequestMessage(engineName, spid, astate);
            SystemMessageTransporter mt = new SystemMessageTransporter("END_PROCESS_REQUEST");
            mt.sendMessage(eprmsg);
        }
    }
}

