/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.WorkItemFilterConverter;
import jp.co.argo21.nautica.workflow.engine.ActivityInternal;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.ProcessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessManagerFactory;
import jp.co.argo21.nautica.workflow.engine.ResourceManagerFactory;
import jp.co.argo21.nautica.workflow.engine.WorkItemPool;
import jp.co.argo21.nautica.workflow.filter.StateFilter;
import jp.co.argo21.nautica.workflow.omg.InvalidStateException;
import jp.co.argo21.nautica.workflow.omg.TransitionNotAllowedException;
import jp.co.argo21.nautica.workflow.omg.WfState;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.OrganizationManager;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.RoleManager;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.UserManager;
import jp.co.argo21.nautica.workflow.util.StateHelper;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;
import jp.co.argo21.nautica.workflow.wfmc.AttributeAssignmentFailedException;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidAttributeException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSourceUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidTargetUserException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidWorkItemException;
import jp.co.argo21.nautica.workflow.wfmc.Participant;
import jp.co.argo21.nautica.workflow.wfmc.WorkItem;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;
import org.apache.log4j.Logger;

public class WorkItemContainer {
    private static Logger eLog = LogManager.getEngineLogger();
    private static long DEFAULT_VALID_TERM = 604800000L;
    private long validTerm = DEFAULT_VALID_TERM;
    private Participant userResource;
    private List orgResources;
    private List roleResources;
    private long createTimeMillis;
    private boolean isExpired;

    WorkItemContainer(Participant user, List orgs, List roles) {
        this(user, orgs, roles, DEFAULT_VALID_TERM);
    }

    WorkItemContainer(Participant user, List orgs, List roles, long validTerm) {
        this.userResource = user;
        this.orgResources = orgs;
        this.roleResources = roles;
        this.createTimeMillis = System.currentTimeMillis();
        this.validTerm = validTerm;
    }

    boolean isExpired() {
        long now = System.currentTimeMillis();
        if (now - this.createTimeMillis > this.validTerm) {
            this.isExpired = true;
        }
        return this.isExpired;
    }

    void expire() {
        this.isExpired = true;
    }

    WorkItem[] getWorkItems(Filter filter) throws InvalidFilterException {
        try {
            WorkItemPool pool = WorkItemPool.getInstance();
            WorkItemFilterConverter conv = new WorkItemFilterConverter();
            String filterPart = conv.convertToSQL(filter);
            String participantPart = this.getParticipantSQLPart();
            StringBuffer sqlPart = new StringBuffer();
            boolean filterExist = !filterPart.equals("");
            boolean hasAttrFilter = conv.hasAttributeFilter();
            sqlPart.append(" where ").append(participantPart);
            if (filterExist) {
                if (hasAttrFilter) {
                    sqlPart.append(" and ").append(filterPart).append(" and (w.PROC_ID = v.PROC_ID)");
                } else {
                    sqlPart.append(" and ").append(filterPart);
                }
            }
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();
            WorkItem[] items = workItemDAO.findBySQLPart(sqlPart.toString(), hasAttrFilter);
            return items;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0174 = StringManager.get("E0174");
            throw new InvalidFilterException(E0174, ex);
        }
    }

    WorkItem getWorkItem(String wid) throws InvalidWorkItemException {
        try {
            WorkItem workItem = this.checkWorkItem(wid);
            return workItem;
        }
        catch (InvalidWorkItemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0116 = StringManager.get("E0116");
            throw new InvalidWorkItemException(E0116, ex);
        }
    }

    void completeWorkItem(String wid) throws InvalidWorkItemException {
        try {
            long now = System.currentTimeMillis();
            Timestamp ts = new Timestamp(now);
            WorkItem workItem = this.checkWorkItem(wid);
            this.checkUsing(wid);
            String pid = workItem.getProcessID();
            String aid = workItem.getActivityID();
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
            ActivityInternal activity = (ActivityInternal)process.getStep(aid);
            activity.changeState(ActivityState.CLOSED_COMPLETED);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();
            try {
                workItemDAO.delete(wid);
            }
            catch (DAOException ex) {}
        }
        catch (InvalidWorkItemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0175 = StringManager.get("E0175");
            throw new InvalidWorkItemException(E0175, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    WorkItemState[] getWorkItemStates(String wid, Filter filter) throws InvalidWorkItemException, InvalidFilterException {
        WorkItemState state = null;
        try {
            if (filter != null) {
                if (!(filter instanceof StateFilter)) {
                    String E0184 = StringManager.get("E0184");
                    throw new InvalidFilterException(E0184);
                }
                WfState st = ((StateFilter)filter).getState();
                if (!(st instanceof WorkItemState)) {
                    String E0183 = StringManager.get("E0183");
                    throw new InvalidFilterException(E0183);
                }
                state = (WorkItemState)st;
            }
            WorkItem workItem = this.checkWorkItem(wid);
            String pid = workItem.getProcessID();
            String aid = workItem.getActivityID();
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
            ActivityInternal activity = (ActivityInternal)process.getStep(aid);
            ActivityBean act = activity.getBean();
            ActivityState astate = ActivityState.getState(act.getActivityState());
            WorkItemState wstate = StateHelper.convert(astate);
            WorkItemState[] ret = null;
            if (filter == null) return WorkItemState.getTransitableStates(wstate.toInt());
            if (state == null) {
                return WorkItemState.getTransitableStates(wstate.toInt());
            }
            if (!StateHelper.containsTransitable(wstate, state)) return new WorkItemState[0];
            ret = new WorkItemState[]{state};
            return ret;
        }
        catch (InvalidWorkItemException ex) {
            throw ex;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0176 = StringManager.get("E0176");
            throw new InvalidWorkItemException(E0176, ex);
        }
    }

    void changeWorkItemState(String session, String wid, WorkItemState state) throws InvalidSessionException, InvalidWorkItemException, jp.co.argo21.nautica.workflow.wfmc.InvalidStateException, jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException {
        try {
            WorkItem workItem = this.checkWorkItem(wid);
            ActivityState astate = StateHelper.convert(state);
            long now = System.currentTimeMillis();
            Timestamp ts = new Timestamp(now);
            String pid = workItem.getProcessID();
            String aid = workItem.getActivityID();
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
            ActivityInternal activity = (ActivityInternal)process.getStep(aid);
            activity.changeState(astate);
            if (state.equals(WorkItemState.CLOSED_COMPLETED) || state.equals(WorkItemState.CLOSED_ABORTED) || state.equals(WorkItemState.CLOSED_TERMINATED)) {
                WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
                WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();
                try {
                    workItemDAO.delete(wid);
                }
                catch (DAOException ex) {}
            }
        }
        catch (InvalidWorkItemException ex) {
            throw ex;
        }
        catch (jp.co.argo21.nautica.workflow.wfmc.InvalidStateException ex) {
            throw ex;
        }
        catch (jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException ex) {
            throw ex;
        }
        catch (TransitionNotAllowedException ex) {
            throw new jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException(ex.getMessage(), ex);
        }
        catch (InvalidStateException ex) {
            throw new jp.co.argo21.nautica.workflow.wfmc.InvalidStateException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            String E0177 = StringManager.get("E0177");
            throw new InvalidWorkItemException(E0177, ex);
        }
    }

    void reassignWorkItem(String wid, Participant sourceUser, Participant targetUser) throws InvalidWorkItemException, InvalidSourceUserException, InvalidTargetUserException {
        try {
            WorkItem workItem = this.checkWorkItem(wid);
            this.checkUsing(wid);
            ResourceManagerFactory rmf = ResourceManagerFactory.getInstance();
            String tpid = targetUser.getID();
            int ptype = targetUser.getType();
            if (ptype == 5) {
                UserManager um = rmf.getUserManager();
                User tuser = um.getUser(tpid);
                if (tuser == null) {
                    String E0185 = StringManager.get("E0185");
                    throw new InvalidTargetUserException(E0185);
                }
            } else if (ptype == 4) {
                OrganizationManager om = rmf.getOrganizationManager();
                Organization torg = om.getOrganization(tpid);
                if (torg == null) {
                    String E0227 = StringManager.get("E0227");
                    throw new InvalidTargetUserException(E0227);
                }
            } else if (ptype == 3) {
                RoleManager rm = rmf.getRoleManager();
                Role trole = rm.getRole(tpid);
                if (trole == null) {
                    String E0228 = StringManager.get("E0228");
                    throw new InvalidTargetUserException(E0228);
                }
            } else {
                String E0229 = StringManager.get("E0229");
                throw new InvalidTargetUserException(E0229);
            }
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();
            workItemDAO.updateParticipant(wid, sourceUser, targetUser);
        }
        catch (InvalidWorkItemException ex) {
            throw ex;
        }
        catch (InvalidTargetUserException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0178 = StringManager.get("E0178");
            throw new InvalidWorkItemException(E0178, ex);
        }
    }

    Attribute[] getWorkItemAttributes(String session, String wid, Filter filter) throws InvalidSessionException, InvalidWorkItemException, InvalidFilterException {
        try {
            WorkItem workItem = this.checkWorkItem(wid);
            this.checkUsing(wid);
            String pid = workItem.getProcessID();
            String aid = workItem.getActivityID();
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
            ActivityInternal activity = (ActivityInternal)process.getStep(aid);
            Attribute[] ret = (Attribute[])activity.getContext(filter);
            return ret;
        }
        catch (InvalidSessionException ex) {
            throw ex;
        }
        catch (InvalidWorkItemException ex) {
            throw ex;
        }
        catch (InvalidFilterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0179 = StringManager.get("E0179");
            throw new InvalidWorkItemException(E0179, ex);
        }
    }

    Attribute getWorkItemAttributeValue(String wid, String name) throws InvalidWorkItemException, InvalidAttributeException {
        try {
            WorkItem workItem = this.checkWorkItem(wid);
            this.checkUsing(wid);
            String pid = workItem.getProcessID();
            String aid = workItem.getActivityID();
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
            ActivityInternal activity = (ActivityInternal)process.getStep(aid);
            Attribute attr = (Attribute)activity.getContext(name);
            return attr;
        }
        catch (InvalidWorkItemException ex) {
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0179 = StringManager.get("E0179");
            throw new InvalidWorkItemException(E0179, ex);
        }
    }

    void assignWorkItemAttribute(String session, String wid, Attribute attr) throws InvalidSessionException, InvalidWorkItemException, InvalidAttributeException, AttributeAssignmentFailedException {
        try {
            WorkItem workItem = this.checkWorkItem(wid);
            this.checkUsing(wid);
            String pid = workItem.getProcessID();
            String aid = workItem.getActivityID();
            ProcessManagerFactory pmf = ProcessManagerFactory.getInstance();
            ProcessManager pm = pmf.getOwnerProcessManager(pid);
            ProcessInternal process = (ProcessInternal)pm.getProcess(pid);
            ActivityInternal activity = (ActivityInternal)process.getStep(aid);
            activity.setContext(attr);
        }
        catch (InvalidSessionException ex) {
            throw ex;
        }
        catch (InvalidWorkItemException ex) {
            throw ex;
        }
        catch (InvalidAttributeException ex) {
            throw ex;
        }
        catch (AttributeAssignmentFailedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0180 = StringManager.get("E0180");
            throw new InvalidWorkItemException(E0180, ex);
        }
    }

    private String getParticipantSQLPart() throws WorkflowException {
        Participant p;
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("((w.PARTICIPANT_TYPE = ").append(5).append(" and w.PARTICIPANT_NAME = '").append(this.userResource.getID()).append("')");
        if (this.orgResources != null && this.orgResources.size() > 0) {
            sb.append("or (w.PARTICIPANT_TYPE = ").append(4);
            it = this.orgResources.iterator();
            p = (Participant)it.next();
            sb.append(" and (w.PARTICIPANT_NAME = '").append(p.getID()).append("' ");
            while (it.hasNext()) {
                p = (Participant)it.next();
                sb.append("or w.PARTICIPANT_NAME = '").append(p.getID()).append("' ");
            }
            sb.append("))");
        }
        if (this.roleResources != null && this.roleResources.size() > 0) {
            sb.append("or (w.PARTICIPANT_TYPE = ").append(3);
            it = this.roleResources.iterator();
            p = (Participant)it.next();
            sb.append(" and (w.PARTICIPANT_NAME = '").append(p.getID()).append("' ");
            while (it.hasNext()) {
                p = (Participant)it.next();
                sb.append("or w.PARTICIPANT_NAME = '").append(p.getID()).append("' ");
            }
            sb.append("))");
        }
        sb.append(")");
        return sb.toString();
    }

    private WorkItem checkWorkItem(String wid) throws Exception {
        String participantPart = this.getParticipantSQLPart();
        StringBuffer sqlPart = new StringBuffer().append(" where w.WORK_ID = '").append(wid).append("' and ").append(participantPart);
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        WorkItemDAO workItemDAO = daoFactory.getWorkItemDAO();
        WorkItemBean[] items = workItemDAO.findBySQLPart(sqlPart.toString(), false);
        if (items.length != 1) {
            String E0181 = StringManager.get("E0181");
            throw new InvalidWorkItemException(E0181);
        }
        return items[0];
    }

    private void checkUsing(String wid) throws InvalidWorkItemException, InvalidFilterException {
        StateFilter filter = new StateFilter(WorkItemState.OPEN_NOT_RUNNING_SUSPENDED);
        WorkItemState[] states = this.getWorkItemStates(wid, filter);
        if (states.length == 0) {
            String E0182 = StringManager.get("E0182");
            throw new InvalidWorkItemException(E0182);
        }
    }
}

