/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.expression;

import java.util.List;
import jp.co.argo21.nautica.workflow.expression.Expression;
import jp.co.argo21.nautica.workflow.expression.LogicalExpression;
import jp.co.argo21.nautica.workflow.expression.RelationalExpression;
import jp.co.argo21.nautica.workflow.expression.UnaryExpression;
import jp.co.argo21.nautica.workflow.xpdl.ConditionalExpressionDocument;
import jp.co.argo21.nautica.workflow.xpdl.LogicalExpressionDocument;
import jp.co.argo21.nautica.workflow.xpdl.RelationalExpressionDocument;
import jp.co.argo21.nautica.workflow.xpdl.UnaryExpressionDocument;
import org.apache.xmlbeans.XmlObject;

public class ConditionalExpression
implements Expression {
    private static final long serialVersionUID = 20050000000000001L;
    private Expression subExpression;

    public ConditionalExpression(Expression exp) {
        this.subExpression = exp;
    }

    public ConditionalExpression(ConditionalExpressionDocument.ConditionalExpression exp) {
        if (exp.isSetUnaryExpression()) {
            UnaryExpressionDocument.UnaryExpression unary = exp.getUnaryExpression();
            this.subExpression = new UnaryExpression(unary);
        } else if (exp.isSetLogicalExpression()) {
            LogicalExpressionDocument.LogicalExpression logic = exp.getLogicalExpression();
            this.subExpression = new LogicalExpression(logic);
        } else if (exp.isSetRelationalExpression()) {
            RelationalExpressionDocument.RelationalExpression rel = exp.getRelationalExpression();
            this.subExpression = new RelationalExpression(rel);
        }
    }

    public void saveTo(XmlObject o) {
        if (o == null) {
            return;
        }
        if (this.subExpression == null) {
            return;
        }
        if (!(o instanceof ConditionalExpressionDocument.ConditionalExpression)) {
            return;
        }
        ConditionalExpressionDocument.ConditionalExpression ce = (ConditionalExpressionDocument.ConditionalExpression)o;
        UnaryExpressionDocument.UnaryExpression exp = null;
        if (this.subExpression instanceof UnaryExpression) {
            exp = ce.addNewUnaryExpression();
        } else if (this.subExpression instanceof LogicalExpression) {
            exp = ce.addNewLogicalExpression();
        } else if (this.subExpression instanceof RelationalExpression) {
            exp = ce.addNewRelationalExpression();
        }
        this.subExpression.saveTo((XmlObject)exp);
    }

    public boolean eval(List list) {
        if (this.subExpression == null) {
            return true;
        }
        return this.subExpression.eval(list);
    }

    public String getExpressionString() {
        String s = "null";
        if (this.subExpression != null) {
            s = this.subExpression.getExpressionString();
        }
        return "(" + s + ")";
    }

    public String getExpressionString(List vars) {
        String s = "null";
        if (this.subExpression != null) {
            s = this.subExpression.getExpressionString(vars);
        }
        return "(" + s + ")";
    }

    public void getAllExpressions(List exps) {
        if (this.subExpression != null) {
            this.subExpression.getAllExpressions(exps);
        }
    }
}

