/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.security.simple;

import javax.naming.InitialContext;
import jp.co.argo21.nautica.workflow.dataaccess.RoleBean;
import jp.co.argo21.nautica.workflow.dataaccess.RoleManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.security.Organization;
import jp.co.argo21.nautica.workflow.security.Role;
import jp.co.argo21.nautica.workflow.security.User;
import jp.co.argo21.nautica.workflow.security.simple.RoleManager;
import jp.co.argo21.nautica.workflow.security.simple.RoleManagerPO;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.WorkflowSecurityException;
import org.apache.log4j.Logger;

public class SimpleRoleManager
implements RoleManager {
    private static final String WORKFLOW_ROLE_MANAGER = "WorkflowRoleManager";
    private static Logger sLog = LogManager.getSercurityLogger();

    public SimpleRoleManager() throws Exception {
        try {
            RoleManagerPO rmPO = new RoleManagerPO(this);
            InitialContext context = new InitialContext();
            context.rebind(WORKFLOW_ROLE_MANAGER, (Object)rmPO);
            sLog.info((Object)StringManager.get("I1007"));
        }
        catch (Exception ex) {
            String errMsg = StringManager.get("E1009");
            sLog.error((Object)errMsg, (Throwable)ex);
            throw ex;
        }
    }

    public Role getRole(String rid) throws WorkflowSecurityException {
        try {
            RoleManagerDAO rolemanagerDAO = this.getRoleManagerDAO();
            RoleBean role = rolemanagerDAO.findByRoleID(rid);
            return role;
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1022") + "(RoleID = " + rid + ")";
            sLog.error((Object)errMsg);
            throw new WorkflowSecurityException(errMsg, e);
        }
    }

    public Role[] getAttachedRoles(Organization org) throws WorkflowSecurityException {
        try {
            RoleManagerDAO rolemanagerDAO = this.getRoleManagerDAO();
            Role[] roles = rolemanagerDAO.findByOrganizationID(org.getID());
            return roles;
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1023");
            sLog.error((Object)errMsg);
            throw new WorkflowSecurityException(errMsg, e);
        }
    }

    public Role[] getAttachedRoles(User user) throws WorkflowSecurityException {
        try {
            RoleManagerDAO rolemanagerDAO = this.getRoleManagerDAO();
            Role[] roles = rolemanagerDAO.findByUserID(user.getID());
            return roles;
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1023");
            sLog.error((Object)errMsg);
            throw new WorkflowSecurityException(errMsg, e);
        }
    }

    public Organization[] getOrganizationsByRole(Role role) throws WorkflowSecurityException {
        try {
            RoleManagerDAO rolemanagerDAO = this.getRoleManagerDAO();
            Organization[] orgs = rolemanagerDAO.findOrganizationsByRoleID(role.getID());
            return orgs;
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1020");
            sLog.error((Object)errMsg);
            throw new WorkflowSecurityException(errMsg, e);
        }
    }

    public User[] getUsersByRole(Role role) throws WorkflowSecurityException {
        try {
            RoleManagerDAO rolemanagerDAO = this.getRoleManagerDAO();
            User[] users = rolemanagerDAO.findUsersByRoleID(role.getID());
            return users;
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E1019");
            sLog.error((Object)errMsg);
            throw new WorkflowSecurityException(errMsg, e);
        }
    }

    private RoleManagerDAO getRoleManagerDAO() throws Exception {
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        return daoFactory.getRoleManagerDAO();
    }
}

