/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.ta;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import jp.co.argo21.nautica.workflow.ta.AppExecutionInfo;
import jp.co.argo21.nautica.workflow.wfmc.Attribute;

public class MailExecutionInfo
extends AppExecutionInfo {
    private static final int MESSAGE_TYPE = 802;
    private InternetAddress from = null;
    private InternetAddress[] to = null;
    private InternetAddress[] cc = null;
    private InternetAddress[] bcc = null;
    private String subject = null;
    private String body = null;
    private String[] attachmentFiles = null;

    MailExecutionInfo(String appName, String toolAgent, String wid, int handler, Attribute[] attrList) {
        this.setAppName(appName);
        this.setToolAgent(toolAgent);
        this.setWid(wid);
        this.setHandler(handler);
        this.setAttributes(attrList);
    }

    public int getMessageType() {
        return 802;
    }

    public InternetAddress getFrom() {
        return this.from;
    }

    public InternetAddress[] getTo() {
        return this.to;
    }

    public InternetAddress[] getCC() {
        return this.cc;
    }

    public InternetAddress[] getBCC() {
        return this.bcc;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public String[] getAttachmentFiles() {
        return this.attachmentFiles;
    }

    public void parse(String encode) throws AddressException, UnsupportedEncodingException {
        this.from = this.parseInternetAddress("MAIL_FROM_ADDRESS", "MAIL_FROM_NAME", encode);
        this.to = this.parseInternetAddresses("MAIL_TO_ADDRESS", "MAIL_TO_NAME", encode);
        this.cc = this.parseInternetAddresses("MAIL_CC_ADDRESS", "MAIL_CC_NAME", encode);
        this.bcc = this.parseInternetAddresses("MAIL_BCC_ADDRESS", "MAIL_BCC_NAME", encode);
        for (int i = 0; i < this.attributes.length; ++i) {
            Attribute attr = this.attributes[i];
            if (!attr.getName().equals("MAIL_SUBJECT")) continue;
            this.subject = attr.getValue();
            break;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.attributes.length; ++i) {
            Attribute attr = this.attributes[i];
            if (!attr.getName().equals("MAIL_BODY")) continue;
            buf.append(attr.getValue());
        }
        String str = new String(buf);
        if (str != null) {
            this.body = str;
        }
        ArrayList<String> tempList = new ArrayList<String>();
        for (int i = 0; i < this.attributes.length; ++i) {
            Attribute attr = this.attributes[i];
            if (!attr.getName().equals("MAIL_ATTACHMENT_FILE")) continue;
            tempList.add(attr.getValue());
        }
        this.attachmentFiles = tempList.toArray(new String[0]);
    }

    private InternetAddress parseInternetAddress(String addr, String personal, String encode) throws AddressException, UnsupportedEncodingException {
        String address = null;
        for (int i = 0; i < this.attributes.length; ++i) {
            Attribute attr = this.attributes[i];
            if (!attr.getName().equals(addr)) continue;
            address = attr.getValue();
            break;
        }
        String name = null;
        for (int i = 0; i < this.attributes.length; ++i) {
            Attribute attr = this.attributes[i];
            if (!attr.getName().equals(personal)) continue;
            name = attr.getValue();
            break;
        }
        InternetAddress result = null;
        result = name != null ? new InternetAddress(address, name, encode) : new InternetAddress(address);
        return result;
    }

    private InternetAddress[] parseInternetAddresses(String addr, String personal, String encode) throws AddressException, UnsupportedEncodingException {
        ArrayList<String> addresses = new ArrayList<String>();
        for (int i = 0; i < this.attributes.length; ++i) {
            Attribute attr = this.attributes[i];
            if (!attr.getName().equals(addr)) continue;
            addresses.add(attr.getValue());
        }
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.attributes.length; ++i) {
            Attribute attr = this.attributes[i];
            if (!attr.getName().equals(personal)) continue;
            names.add(attr.getValue());
        }
        ArrayList<InternetAddress> tempList = new ArrayList<InternetAddress>();
        for (int i = 0; i < addresses.size(); ++i) {
            String address = (String)addresses.get(i);
            String name = null;
            if (i < names.size()) {
                name = (String)names.get(i);
            }
            InternetAddress temp = null;
            temp = name != null ? new InternetAddress(address, name, encode) : new InternetAddress(address);
            tempList.add(temp);
        }
        return tempList.toArray(new InternetAddress[0]);
    }
}

