/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.ta;

import java.util.HashMap;
import java.util.Map;
import jp.co.argo21.nautica.workflow.ta.config.App;
import jp.co.argo21.nautica.workflow.ta.config.Script;
import jp.co.argo21.nautica.workflow.ta.config.ScriptingDocument;
import jp.co.argo21.nautica.workflow.ta.config.Scripts;

public class ScriptingConfig {
    private String user = null;
    private String password = null;
    private Map applications = new HashMap();

    ScriptingConfig(ScriptingDocument.Scripting scripting) {
        this.user = scripting.getAuthentication().getUser();
        this.password = scripting.getAuthentication().getPassword();
        Scripts scriptlist = scripting.getScripts();
        if (scriptlist == null) {
            return;
        }
        Script[] scripts = scriptlist.getScriptArray();
        for (int i = 0; i < scripts.length; ++i) {
            Script script = scripts[i];
            App[] apps = scripts[i].getAppArray();
            for (int j = 0; j < apps.length; ++j) {
                this.applications.put(apps[j].getName(), script);
            }
        }
    }

    public boolean existApplication(String appName) {
        return this.applications.containsKey(appName);
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    private Script getScript(String appName) {
        return (Script)this.applications.get(appName);
    }

    public String getEngineName(String appName) {
        Script script = this.getScript(appName);
        if (script == null) {
            return null;
        }
        return script.getEngine().getName();
    }

    public String getType(String appName) {
        Script script = this.getScript(appName);
        if (script == null) {
            return null;
        }
        return script.getType();
    }

    public String getFilename(String appName) {
        Script script = this.getScript(appName);
        if (script == null) {
            return null;
        }
        return script.getFilename();
    }

    public String getCommand(String appName) {
        Script script = this.getScript(appName);
        if (script == null) {
            return null;
        }
        return script.getCommand();
    }
}

