/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.wfmc;

import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.omg.WfState;

public final class ActivityState
implements WfState {
    private static final long serialVersionUID = 20050000000000001L;
    public static final ActivityState OPEN_NOT_RUNNING_NOT_STARTED = new ActivityState("open.not_running.not_started", 1);
    public static final ActivityState OPEN_NOT_RUNNING_SUSPENDED = new ActivityState("open.not_running.suspended", 2);
    public static final ActivityState OPEN_RUNNING = new ActivityState("open.running", 3);
    public static final ActivityState CLOSED_COMPLETED = new ActivityState("closed.completed", 4);
    public static final ActivityState CLOSED_TERMINATED = new ActivityState("closed.terminated", 5);
    public static final ActivityState CLOSED_ABORTED = new ActivityState("closed.aborted", 6);
    private String stateString;
    private int stateNum;

    public static ActivityState getState(int n) {
        switch (n) {
            case 1: {
                return OPEN_NOT_RUNNING_NOT_STARTED;
            }
            case 2: {
                return OPEN_NOT_RUNNING_SUSPENDED;
            }
            case 3: {
                return OPEN_RUNNING;
            }
            case 4: {
                return CLOSED_COMPLETED;
            }
            case 5: {
                return CLOSED_TERMINATED;
            }
            case 6: {
                return CLOSED_ABORTED;
            }
        }
        return null;
    }

    public static ActivityState[] getTransitableStates(int n) {
        ArrayList<ActivityState> states = new ArrayList<ActivityState>();
        switch (n) {
            case 1: 
            case 2: {
                states.add(OPEN_RUNNING);
                states.add(CLOSED_COMPLETED);
                states.add(CLOSED_TERMINATED);
                states.add(CLOSED_ABORTED);
                break;
            }
            case 3: {
                states.add(OPEN_NOT_RUNNING_SUSPENDED);
                states.add(CLOSED_COMPLETED);
                states.add(CLOSED_TERMINATED);
                states.add(CLOSED_ABORTED);
            }
        }
        return states.toArray(new ActivityState[0]);
    }

    private ActivityState(String s, int i) {
        this.stateString = s;
        this.stateNum = i;
    }

    public String toString() {
        return this.stateString;
    }

    public int toInt() {
        return this.stateNum;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ActivityState)) {
            return false;
        }
        ActivityState s = (ActivityState)obj;
        return this.stateNum == s.stateNum && this.stateString.equals(s.stateString);
    }

    public int hashCode() {
        return this.stateString.hashCode();
    }
}

