/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.invocation;

import com.sun.script.invocation.ConversionException;
import com.sun.script.invocation.Invoker;
import com.sun.script.invocation.TypeConverter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;

public class GenericConverter
implements TypeConverter {
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;

    public Object convert(Object source, Class target) throws ConversionException {
        if (source == null && target.isPrimitive()) {
            throw new ConversionException("Cannot convert " + source + " to " + target);
        }
        if (!(source != null || (class$java$lang$Number == null ? (class$java$lang$Number = GenericConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(target) || target.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = GenericConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean) || target.equals(class$java$lang$Character == null ? (class$java$lang$Character = GenericConverter.class$("java.lang.Character")) : class$java$lang$Character))) {
            return null;
        }
        if (target.isAssignableFrom(source.getClass())) {
            return source;
        }
        if (target.isArray()) {
            return this.convertArray(source, target);
        }
        if (target.equals(class$java$lang$String == null ? (class$java$lang$String = GenericConverter.class$("java.lang.String")) : class$java$lang$String)) {
            return source.toString();
        }
        if ((target.equals(class$java$lang$Character == null ? (class$java$lang$Character = GenericConverter.class$("java.lang.Character")) : class$java$lang$Character) || target.equals(Character.TYPE)) && source instanceof String) {
            String str = (String)source;
            if (str.length() == 1) {
                return new Character(str.charAt(0));
            }
            throw new ConversionException("Cannot convert String with more than one character to Character");
        }
        if (target.equals(class$java$lang$Double == null ? (class$java$lang$Double = GenericConverter.class$("java.lang.Double")) : class$java$lang$Double) || target.equals(Double.TYPE)) {
            if (source instanceof Number) {
                return new Double(((Number)source).doubleValue());
            }
            throw new ConversionException("Cannot convert " + source + " to " + target);
        }
        if (this.isNumber(source)) {
            return this.convertNumber((Number)source, target);
        }
        if (source instanceof Boolean && target.equals(Boolean.TYPE)) {
            return new Boolean((Boolean)source);
        }
        throw new ConversionException("Cannot convert " + source + " to " + target + ".");
    }

    public int convertPenalty(Object source, Class target) {
        if (!(source != null || (class$java$lang$Number == null ? (class$java$lang$Number = GenericConverter.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(target) || target.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = GenericConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean) || target.equals(class$java$lang$Character == null ? (class$java$lang$Character = GenericConverter.class$("java.lang.Character")) : class$java$lang$Character))) {
            Invoker.dbgPrint("source = null.. converting to " + target);
            return 1;
        }
        if (target.isArray()) {
            Invoker.dbgPrint("converting array.. source = " + source + " target = " + target);
            return this.convertArrayPenalty(source, target);
        }
        Invoker.dbgPrint("source class = " + source.getClass() + " target = " + target + " class Name = " + target.getName());
        if (source.getClass().equals(target)) {
            return 1;
        }
        Invoker.dbgPrint(" convertPenalty : not equal ");
        if (target.isAssignableFrom(source.getClass())) {
            Invoker.dbgPrint(" convertPenalty : Is assignable from true ");
            if (target.isInterface()) {
                return 1;
            }
            return 2;
        }
        if ((target.equals(class$java$lang$Character == null ? (class$java$lang$Character = GenericConverter.class$("java.lang.Character")) : class$java$lang$Character) || target.equals(Character.TYPE)) && source instanceof String) {
            String str = (String)source;
            if (str.length() == 1) {
                return 1;
            }
            return 0;
        }
        if (target.equals(class$java$lang$String == null ? (class$java$lang$String = GenericConverter.class$("java.lang.String")) : class$java$lang$String)) {
            return 1000;
        }
        if (this.isNumber(source)) {
            Invoker.dbgPrint(" convertPenalty : Is Number ");
            return this.convertNumberPenalty((Number)source, target);
        }
        if (source instanceof Boolean) {
            Invoker.dbgPrint("source class is Boolean");
            if (target.equals(Boolean.TYPE)) {
                Invoker.dbgPrint("target is a boolean class : returning 0");
                return 1;
            }
        }
        return 0;
    }

    protected Object convertNumber(Number source, Class target) throws ConversionException {
        if (target.equals(class$java$lang$Double == null ? (class$java$lang$Double = GenericConverter.class$("java.lang.Double")) : class$java$lang$Double) || target.equals(Double.TYPE)) {
            return new Double(source.doubleValue());
        }
        if (target.equals(class$java$lang$Float == null ? (class$java$lang$Float = GenericConverter.class$("java.lang.Float")) : class$java$lang$Float) || target.equals(Float.TYPE)) {
            double f = source.doubleValue();
            if (this.overflows(f, 1.4E-45f, 3.4028234663852886E38)) {
                throw new ConversionException("Cannot convert " + source.floatValue() + " to Float (overflow.)");
            }
            return new Float(source.floatValue());
        }
        if (!this.isIntegral(source)) {
            throw new ConversionException("Cannot convert " + source.doubleValue() + " to " + target + " (truncation.)");
        }
        if (target.equals(class$java$lang$Long == null ? (class$java$lang$Long = GenericConverter.class$("java.lang.Long")) : class$java$lang$Long) || target.equals(Long.TYPE)) {
            double l = source.doubleValue();
            if (this.overflows(l, -9.223372036854776E18, 9.223372036854776E18)) {
                throw new ConversionException("Cannot convert " + source.doubleValue() + " to Long (overflow.)");
            }
            return new Long(source.longValue());
        }
        if (target.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = GenericConverter.class$("java.lang.Integer")) : class$java$lang$Integer) || target.equals(Integer.TYPE)) {
            double i = source.doubleValue();
            if (this.overflows(i, -2.147483648E9, 2.147483647E9)) {
                throw new ConversionException("Cannot convert " + source.doubleValue() + " to Integer (overflow.)");
            }
            return new Integer(source.intValue());
        }
        if (target.equals(class$java$lang$Short == null ? (class$java$lang$Short = GenericConverter.class$("java.lang.Short")) : class$java$lang$Short) || target.equals(Short.TYPE)) {
            double s = source.doubleValue();
            if (this.overflows(s, -32768.0, 32767.0)) {
                throw new ConversionException("Cannot convert " + source.doubleValue() + " to Short (overflow.)");
            }
            return new Short(source.shortValue());
        }
        if (target.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = GenericConverter.class$("java.lang.Byte")) : class$java$lang$Byte) || target.equals(Byte.TYPE)) {
            double b = source.doubleValue();
            if (this.overflows(b, -128.0, 127.0)) {
                throw new ConversionException("Cannot convert " + source.doubleValue() + " to Byte (overflow.)");
            }
            return new Byte(source.byteValue());
        }
        throw new ConversionException("Cannot convert " + source.doubleValue() + " to non-numeric type " + target + ".");
    }

    protected int convertNumberPenalty(Number source, Class target) {
        if (target.equals(class$java$lang$Double == null ? (class$java$lang$Double = GenericConverter.class$("java.lang.Double")) : class$java$lang$Double) || target.equals(Double.TYPE)) {
            return 6;
        }
        if (target.equals(class$java$lang$Float == null ? (class$java$lang$Float = GenericConverter.class$("java.lang.Float")) : class$java$lang$Float) || target.equals(Float.TYPE)) {
            double f = source.floatValue();
            if (this.overflows(f, 1.4E-45f, 3.4028234663852886E38)) {
                return 0;
            }
            if (source.getClass().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = GenericConverter.class$("java.lang.Integer")) : class$java$lang$Integer) || source.getClass().equals(Integer.TYPE)) {
                return 6;
            }
            return 2;
        }
        if (!this.isIntegral(source)) {
            return 0;
        }
        if (target.equals(class$java$lang$Long == null ? (class$java$lang$Long = GenericConverter.class$("java.lang.Long")) : class$java$lang$Long) || target.equals(Long.TYPE)) {
            double l = source.longValue();
            if (this.overflows(l, -9.223372036854776E18, 9.223372036854776E18)) {
                return 0;
            }
            return 1;
        }
        if (target.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = GenericConverter.class$("java.lang.Integer")) : class$java$lang$Integer) || target.equals(Integer.TYPE)) {
            int i = source.intValue();
            if (this.overflows(i, -2.147483648E9, 2.147483647E9)) {
                return 0;
            }
            return 1;
        }
        if (target.equals(class$java$lang$Short == null ? (class$java$lang$Short = GenericConverter.class$("java.lang.Short")) : class$java$lang$Short) || target.equals(Short.TYPE)) {
            short s = source.shortValue();
            if (this.overflows(s, -32768.0, 32767.0)) {
                return 0;
            }
            return 1;
        }
        if (target.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = GenericConverter.class$("java.lang.Byte")) : class$java$lang$Byte) || target.equals(Byte.TYPE)) {
            byte b = source.byteValue();
            if (this.overflows(b, -128.0, 127.0)) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    protected Object convertArray(Object array, Class arrayClass) throws ConversionException {
        if (array == null) {
            return null;
        }
        if (!array.getClass().isArray()) {
            throw new ConversionException("Cannon convert non-array " + array + " to array type.");
        }
        Class clasz = this.getArrayType(arrayClass);
        int size = Array.getLength(array);
        Object ret = Array.newInstance(clasz, size);
        for (int i = 0; i < size; ++i) {
            Object obj = Array.get(array, i);
            Object element = this.convert(obj, clasz);
            this.setArrayElement(ret, i, element, clasz);
        }
        return ret;
    }

    protected int convertArrayPenalty(Object array, Class arrayClass) {
        if (array == null) {
            return 1;
        }
        if (!array.getClass().isArray()) {
            return 0;
        }
        Class clasz = this.getArrayType(arrayClass);
        int penalty = 1;
        int size = Array.getLength(array);
        for (int i = 0; i < size; ++i) {
            Object obj = Array.get(array, i);
            int p = this.convertPenalty(obj, clasz);
            if (p == 0) {
                return 0;
            }
            if (p <= penalty) continue;
            penalty = p;
        }
        return penalty;
    }

    protected void setArrayElement(Object arr, int index, Object element, Class clasz) {
        if (!clasz.isPrimitive()) {
            Array.set(arr, index, element);
        }
        if (clasz.equals(Byte.TYPE)) {
            Array.setByte(arr, index, (Byte)element);
        } else if (clasz.equals(Integer.TYPE)) {
            Array.setInt(arr, index, (Integer)element);
        } else if (clasz.equals(Short.TYPE)) {
            Array.setShort(arr, index, (Short)element);
        } else if (clasz.equals(Long.TYPE)) {
            Array.setLong(arr, index, (Long)element);
        } else if (clasz.equals(Float.TYPE)) {
            Array.setFloat(arr, index, ((Float)element).floatValue());
        } else if (clasz.equals(Short.TYPE)) {
            Array.setDouble(arr, index, (Double)element);
        } else if (clasz.equals(Boolean.TYPE)) {
            Array.setBoolean(arr, index, (Boolean)element);
        } else if (clasz.equals(Character.TYPE)) {
            Array.setChar(arr, index, ((Character)element).charValue());
        }
    }

    protected boolean isNumber(Object o) {
        return o instanceof Number && !(o instanceof BigDecimal) && !(o instanceof BigInteger);
    }

    protected boolean overflows(double d, double min, double max) {
        return !(d >= min) || !(d <= max);
    }

    protected boolean isIntegral(Number num) {
        double d = num.doubleValue();
        return d == Math.rint(d);
    }

    protected Class getArrayType(Class clsType) {
        try {
            if (!clsType.isArray()) {
                throw new IllegalArgumentException("Class is not an array type.");
            }
            String clsName = clsType.getName();
            if (clsName.charAt(1) == '[') {
                return Class.forName(clsName.substring(1));
            }
            char c = clsName.charAt(1);
            int len = clsName.length();
            Class<Comparable<Byte>> clazz = null;
            switch (clsName.charAt(1)) {
                case 'B': {
                    clazz = Byte.TYPE;
                    break;
                }
                case 'C': {
                    clazz = Character.TYPE;
                    break;
                }
                case 'D': {
                    clazz = Double.TYPE;
                    break;
                }
                case 'F': {
                    clazz = Float.TYPE;
                    break;
                }
                case 'I': {
                    clazz = Integer.TYPE;
                    break;
                }
                case 'J': {
                    clazz = Long.TYPE;
                    break;
                }
                case 'S': {
                    clazz = Short.TYPE;
                    break;
                }
                case 'Z': {
                    clazz = Boolean.TYPE;
                    break;
                }
                case 'L': {
                    clsName = clsName.substring(2, len - 1);
                    clazz = Class.forName(clsName);
                }
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

