/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.javascript;

import com.sun.script.javascript.ExternalScriptable;
import com.sun.script.javascript.RhinoCompiledScript;
import com.sun.script.javascript.RhinoScriptEngineFactory;
import com.sun.script.util.InterfaceImplementor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.GenericScriptEngine;
import javax.script.Invocable;
import javax.script.Namespace;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineInfo;
import javax.script.ScriptException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class RhinoScriptEngine
extends GenericScriptEngine
implements Invocable,
Compilable {
    private Namespace globalScope;
    private ExternalScriptable scope = new ExternalScriptable(this);
    private ScriptEngineInfo engineInfo;
    private InterfaceImplementor implementor = new InterfaceImplementor(this);

    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        Object ret;
        ExternalScriptable oldScope = this.scope;
        Scriptable newScope = this.getRuntimeScope(context);
        Context cx = Context.enter(null);
        try {
            String filename = (String)this.get("javax.script.filename");
            filename = filename == null ? "<Unknown source>" : filename;
            ret = cx.evaluateReader(newScope, reader, filename, 1, null);
        }
        catch (EcmaError ec) {
            ec.printStackTrace();
            int line = ec.getLineNumber();
            line = line == 0 ? -1 : line;
            throw new ScriptException(ec.toString(), ec.getSourceName(), line);
        }
        catch (JavaScriptException e) {
            e.printStackTrace();
            throw new ScriptException((Exception)((Object)e));
        }
        catch (IOException ee) {
            throw new ScriptException(ee);
        }
        finally {
            this.scope = oldScope;
            cx.exit();
        }
        if (ret instanceof NativeJavaObject) {
            ret = ((NativeJavaObject)ret).unwrap();
        }
        return ret instanceof Undefined ? null : ret;
    }

    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    public ScriptEngineFactory getFactory() {
        if (this.engineInfo != null) {
            return (ScriptEngineFactory)this.engineInfo;
        }
        return new RhinoScriptEngineFactory();
    }

    public Object get(String name) {
        return this.scope.get(name);
    }

    public void remove(String name) {
        this.scope.remove(name);
    }

    public void put(String name, Object value) {
        this.scope.put(name, value);
    }

    public Namespace createNamespace() {
        return new ExternalScriptable(this);
    }

    public Object call(String name, Object[] args) throws ScriptException, NoSuchMethodException {
        return this.call(name, null, args);
    }

    public Object call(String name, Object thiz, Object[] args) throws ScriptException, NoSuchMethodException {
        Context cx = null;
        try {
            cx = Context.enter();
            if (thiz != null && !(thiz instanceof Scriptable)) {
                throw new IllegalArgumentException(thiz + " is not a javascript object.");
            }
            Object localscope = thiz != null ? (Scriptable)thiz : this.scope;
            Object obj = localscope.get(name, localscope);
            if (obj == null || !(obj instanceof Function)) {
                throw new NoSuchMethodException();
            }
            Object result = ((Function)obj).call(cx, localscope, (Scriptable)(thiz != null ? (Scriptable)thiz : this.scope), args);
            if (result instanceof NativeJavaObject) {
                result = ((NativeJavaObject)result).unwrap();
            }
            if (result != null) {
                // empty if block
            }
            Object object = result instanceof Undefined ? null : result;
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ScriptException(e);
        }
        finally {
            cx.exit();
        }
    }

    public Object getInterface(Class clasz) {
        try {
            return this.implementor.getInterface(null, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    Scriptable getRuntimeScope(ScriptContext context) {
        Namespace scriptNamespace = context.getNamespace(100);
        ExternalScriptable newScope = scriptNamespace != null && scriptNamespace != this.scope ? (scriptNamespace instanceof ExternalScriptable ? (ExternalScriptable)scriptNamespace : new ExternalScriptable(scriptNamespace)) : this.scope;
        Namespace global = context.getNamespace(200);
        if (global != null) {
            newScope.setGlobal(global);
        }
        newScope.put("context", (Object)context);
        return newScope;
    }

    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    public CompiledScript compile(Reader script) throws ScriptException {
        RhinoCompiledScript ret = null;
        Context cx = Context.enter();
        try {
            String fileName = null;
            if (this.scope != null) {
                fileName = (String)this.scope.get("javax.script.filename");
            }
            if (fileName == null) {
                fileName = "<Unknown Source>";
            }
            Scriptable sc = this.getRuntimeScope(this.getScriptContext(this.scope));
            Script scr = cx.compileReader(sc, script, fileName, 0, null);
            ret = new RhinoCompiledScript(this, scr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ScriptException(e);
        }
        finally {
            cx.exit();
        }
        return ret;
    }

    void setEngineInfo(ScriptEngineInfo info) {
        this.engineInfo = info;
    }

    Object unwrapReturnValue(Object result) {
        if (result instanceof NativeJavaObject) {
            result = ((NativeJavaObject)result).unwrap();
        }
        return result instanceof Undefined ? null : result;
    }

    static Context getCurrentContext() {
        Context ctxt = Context.getCurrentContext();
        if (ctxt == null) {
            ctxt = Context.enter();
            ctxt.exit();
        }
        return ctxt;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("No file specified");
            return;
        }
        InputStreamReader r = new InputStreamReader(new FileInputStream(args[0]));
        RhinoScriptEngine engine = new RhinoScriptEngine();
        engine.put("x", "y");
        engine.put("javax.script.filename", args[0]);
        engine.eval(r);
        System.out.println(engine.get("x"));
    }
}

