/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.php;

import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.script.Namespace;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PHPBridge {
    private static final int ADD_SESSION_VAR = 1;
    private static final int REMOVE_SESSION_VAR = 2;

    public static native void init();

    public static native void term();

    public static native void execute(Reader var0, Writer var1, HttpServletRequest var2, HttpServletResponse var3, Servlet var4, Namespace var5, boolean var6) throws Throwable;

    public static native void resetRequest() throws Throwable;

    public static native void putValue(String var0, Object var1);

    public static native Object getValue(String var0);

    public static native void sleep();

    public static void pause() {
        Integer ig = Integer.getInteger("com.sun.php.pause");
        int interval = 0;
        if (ig == null) {
            return;
        }
        interval = ig;
        PHPBridge.sleep();
        try {
            Thread.currentThread();
            Thread.sleep(interval * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String[] getNames(Namespace n) {
        int size = n.size();
        String[] ret = new String[size];
        if (size == 0) {
            return ret;
        }
        Iterator it = n.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i++] = (String)it.next();
        }
        return ret;
    }

    public static void headerHelper(HttpServletResponse res, String header, boolean replace) throws Exception {
        String errorMessage = "Malformed argument passed to header - " + header;
        if (res == null) {
            return;
        }
        if (header.startsWith("HTTP/1")) {
            int code;
            int space = header.indexOf(" ");
            if (space == -1) {
                throw new IllegalArgumentException(errorMessage);
            }
            if ((space = (header = header.substring(space + 1)).indexOf(" ")) == -1) {
                throw new IllegalArgumentException(errorMessage);
            }
            String num = header.substring(0, space);
            String message = header.substring(space + 1).trim();
            try {
                code = Integer.parseInt(num);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(errorMessage);
            }
            if (code != 200 && code != 302) {
                res.sendError(code, message);
            }
            return;
        }
        int colon = header.indexOf(":");
        if (colon == -1) {
            throw new IllegalArgumentException(errorMessage);
        }
        String name = header.substring(0, colon);
        ++colon;
        while (header.charAt(colon) == ' ') {
            ++colon;
        }
        String value = header.substring(colon).trim();
        if (name.equals("Content-type")) {
            res.setContentType(value);
        } else if (name.equals("Location")) {
            res.sendRedirect(value);
        } else if (replace) {
            res.setHeader(name, value);
        } else {
            res.addHeader(name, value);
        }
    }

    public static int readPostHelper(HttpServletRequest req, byte[] bytes, int b) throws Exception {
        return req.getInputStream().read(bytes);
    }

    private static HashMap getServerVariableHash(HttpServlet servlet, HttpServletRequest req) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ServletContext servletContext = servlet.getServletContext();
        String strMethod = req.getMethod();
        hashMap.put("REQUEST_METHOD", strMethod);
        String strProtocol = req.getProtocol();
        hashMap.put("SERVER_PROTOCOL", strProtocol);
        String strURI = req.getRequestURI();
        hashMap.put("PHP_SELF", strURI);
        hashMap.put("REQUEST_URI", strURI);
        hashMap.put("SCRIPT_NAME", strURI);
        String strVal = String.valueOf(req.getServerPort());
        hashMap.put("SERVER_PORT", strVal);
        strVal = req.getServerName();
        hashMap.put("SERVER_NAME", strVal);
        strVal = req.getRemoteAddr();
        hashMap.put("REMOTE_ADDR", strVal);
        strVal = req.getRemoteHost();
        hashMap.put("REMOTE_HOST", strVal);
        strVal = req.getRemoteUser();
        hashMap.put("REMOTE_USER", strVal);
        strVal = req.getHeader("Accept-Language");
        hashMap.put("HTTP_ACCEPT_LANGUAGE", strVal);
        strVal = req.getHeader("User-Agent");
        hashMap.put("HTTP_USER_AGENT", strVal);
        strVal = req.getHeader("Accept");
        hashMap.put("HTTP_ACCEPT", strVal);
        strVal = req.getPathTranslated();
        hashMap.put("SCRIPT_FILENAME", strVal);
        return hashMap;
    }

    public static native void pushArrayElem(String var0, String var1, long var2);

    public static void makeServerVariableArray(HttpServlet servlet, HttpServletRequest req, long lArrayObj) {
        HashMap hashMap = PHPBridge.getServerVariableHash(servlet, req);
        Iterator it = hashMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object val = hashMap.get(key);
            String strKey = (String)key;
            String strVal = (String)val;
            PHPBridge.pushArrayElem(strKey, strVal, lArrayObj);
        }
    }

    public static Object sessionHelper(HttpServletRequest req, String strSessionKey, Object objectValue, int operation) {
        HttpSession session = null;
        if (operation == 2) {
            session = req.getSession(false);
            if (session == null) {
                return null;
            }
        } else {
            session = req.getSession(true);
        }
        Object value = session.getAttribute(strSessionKey);
        if (operation == 1) {
            session.setAttribute(strSessionKey, objectValue);
        }
        if (operation == 2) {
            if (value != null) {
                session.removeAttribute(strSessionKey);
            }
            Enumeration enumNames = session.getAttributeNames();
            int nCount = 0;
            while (enumNames.hasMoreElements()) {
                enumNames.nextElement();
                ++nCount;
            }
            if (nCount == 0) {
                session.invalidate();
            }
        }
        return value;
    }

    public static native Object invokeMethod(Writer var0, long var1, String var3, Object[] var4) throws Throwable;

    static {
        System.loadLibrary("php5");
    }
}

