/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JwsdpCobundleInstallHelper {
    String argLibraryPath;
    String fileName;

    public void debugPrint(String string) {
    }

    public JwsdpCobundleInstallHelper(String fileName, String argLibraryPath) {
        this.fileName = fileName;
        this.argLibraryPath = argLibraryPath;
    }

    boolean removeJavaLibraryPathInShellScript(Vector fileLines) throws Exception {
        int len = fileLines.size();
        String ignoreComment = "#.*$";
        Pattern regexComment = Pattern.compile(ignoreComment);
        String pattern = "\\s*CATALINA_OPTS=.*\"-Djava.library.path=" + this.argLibraryPath + "\\s+\\$CATALINA_OPTS\\s*\"$";
        this.debugPrint("pattern = " + pattern);
        Pattern regexPattern = Pattern.compile(pattern);
        for (int index = 0; index < len; ++index) {
            String curLine = (String)fileLines.get(index);
            Matcher m = regexComment.matcher(curLine);
            curLine = m.replaceFirst("");
            if (!(m = regexPattern.matcher(curLine)).matches()) continue;
            this.debugPrint("matches regexp");
            fileLines.remove(index);
            return false;
        }
        return true;
    }

    boolean addJavaLibraryPathInShellScript(Vector fileLines) throws Exception {
        int len = fileLines.size();
        String ignoreComment = "#.*$";
        Pattern regexComment = Pattern.compile(ignoreComment);
        String pattern = "\\s*CATALINA_OPTS=.*\"-Djava.library.path=" + this.argLibraryPath + "\\s+.*";
        this.debugPrint("pattern = " + pattern);
        Pattern regexPattern = Pattern.compile(pattern);
        for (int index = 0; index < len; ++index) {
            String curLine = (String)fileLines.get(index);
            Matcher m = regexComment.matcher(curLine);
            curLine = m.replaceFirst("");
            if (!(m = regexPattern.matcher(curLine)).matches()) continue;
            this.debugPrint("matches regexp");
            return true;
        }
        String lineToAdd = "CATALINA_OPTS=\"-Djava.library.path=" + this.argLibraryPath + " $CATALINA_OPTS\"";
        fileLines.insertElementAt(lineToAdd, len);
        lineToAdd = "export CATALINA_OPTS";
        fileLines.insertElementAt(lineToAdd, len + 1);
        return false;
    }

    boolean addModificationInBatchFile(Vector fileLines) throws Exception {
        int len = fileLines.size();
        String ignoreComment = "^\\s*rem\\s*.*$";
        Pattern regexComment = Pattern.compile(ignoreComment);
        String argLibraryPathModified = this.argLibraryPath.replaceAll("\\\\", "\\\\\\\\");
        argLibraryPathModified = argLibraryPathModified.replaceAll("/", "\\\\\\\\");
        String pattern = "\\s*set CATALINA_OPTS=-Djava.library.path=" + argLibraryPathModified + "\\s+.*";
        this.debugPrint("pattern = " + pattern);
        Pattern regexPattern = Pattern.compile(pattern);
        for (int index = 0; index < len; ++index) {
            String curLine = (String)fileLines.get(index);
            Matcher m = regexComment.matcher(curLine);
            curLine = m.replaceFirst("");
            this.debugPrint("curLine = " + curLine);
            m = regexPattern.matcher(curLine);
            if (!m.matches()) continue;
            this.debugPrint("matches regexp");
            return true;
        }
        argLibraryPathModified = this.argLibraryPath.replaceAll("/", "\\\\");
        String lineToAdd = "set CATALINA_OPTS=-Djava.library.path=" + argLibraryPathModified + " %CATALINA_OPTS%";
        fileLines.insertElementAt(lineToAdd, len);
        lineToAdd = "set PATH=" + argLibraryPathModified + ";%PATH%";
        fileLines.insertElementAt(lineToAdd, len + 1);
        return false;
    }

    boolean removeModificationInBatchFile(Vector fileLines) throws Exception {
        int len = fileLines.size();
        String argLibraryPathModified = this.argLibraryPath.replaceAll("\\\\", "\\\\\\\\");
        argLibraryPathModified = argLibraryPathModified.replaceAll("/", "\\\\\\\\");
        this.debugPrint("modified path = " + argLibraryPathModified);
        String ignoreComment = "^\\s*rem\\s*.*$";
        Pattern regexComment = Pattern.compile(ignoreComment);
        String pattern = "\\s*set CATALINA_OPTS=-Djava.library.path=" + argLibraryPathModified + "\\s+%CATALINA_OPTS%\\s*$";
        this.debugPrint("pattern = " + pattern);
        Pattern regexPattern = Pattern.compile(pattern);
        pattern = "\\s*set PATH=" + argLibraryPathModified + ";%PATH%$";
        this.debugPrint("pattern = " + pattern);
        Pattern regexPattern1 = Pattern.compile(pattern);
        boolean bRetVal = true;
        for (int index = 0; index < len; ++index) {
            String curLine = (String)fileLines.get(index);
            Matcher m = regexComment.matcher(curLine);
            curLine = m.replaceFirst("");
            this.debugPrint("curLine = " + curLine);
            m = regexPattern.matcher(curLine);
            if (m.matches()) {
                this.debugPrint("matches regexp");
                fileLines.remove(index);
                bRetVal = false;
                len = fileLines.size();
                --index;
                continue;
            }
            m = regexPattern1.matcher(curLine);
            if (!m.matches()) continue;
            this.debugPrint("matches regexp1");
            fileLines.remove(index);
            bRetVal = false;
            len = fileLines.size();
            --index;
        }
        return bRetVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean readLines(Vector fileLines) throws IOException {
        FileReader fileReader;
        block8: {
            fileReader = null;
            BufferedReader bufReader = null;
            try {
                try {
                    String line;
                    fileReader = new FileReader(this.fileName);
                    bufReader = new BufferedReader(fileReader);
                    while ((line = bufReader.readLine()) != null) {
                        fileLines.insertElementAt(line, fileLines.size());
                    }
                    Object var7_6 = null;
                    if (bufReader == null) break block8;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    boolean bl = false;
                    Object var7_7 = null;
                    if (bufReader != null) {
                        bufReader.close();
                    }
                    if (fileReader == null) return bl;
                    fileReader.close();
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (bufReader != null) {
                    bufReader.close();
                }
                if (fileReader == null) throw throwable;
                fileReader.close();
                throw throwable;
            }
            bufReader.close();
        }
        if (fileReader == null) return true;
        fileReader.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeLines(Vector fileLines) throws IOException {
        FileWriter fileWriter;
        block8: {
            fileWriter = null;
            BufferedWriter bufWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(this.fileName);
                    bufWriter = new BufferedWriter(fileWriter);
                    Enumeration e = fileLines.elements();
                    while (e.hasMoreElements()) {
                        String str = (String)e.nextElement();
                        bufWriter.write(str, 0, str.length());
                        bufWriter.newLine();
                    }
                    System.out.println("Modified Startup file " + this.fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    boolean bl = false;
                    Object var8_8 = null;
                    if (bufWriter != null) {
                        bufWriter.close();
                    }
                    if (fileWriter == null) return bl;
                    fileWriter.close();
                    return bl;
                }
                Object var8_7 = null;
                if (bufWriter == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (bufWriter != null) {
                    bufWriter.close();
                }
                if (fileWriter == null) throw throwable;
                fileWriter.close();
                throw throwable;
            }
            bufWriter.close();
        }
        if (fileWriter == null) return true;
        fileWriter.close();
        return true;
    }

    boolean addJavaLibraryPath() throws Exception {
        Vector fileLines = new Vector(100);
        if (!this.readLines(fileLines)) {
            return false;
        }
        if (this.fileName.matches(".+.sh$")) {
            if (this.addJavaLibraryPathInShellScript(fileLines)) {
                return true;
            }
        } else if (this.fileName.matches(".+.bat$")) {
            if (this.addModificationInBatchFile(fileLines)) {
                return true;
            }
        } else {
            return false;
        }
        return this.writeLines(fileLines);
    }

    boolean removeJavaLibraryPath() throws Exception {
        Vector fileLines = new Vector(100);
        if (!this.readLines(fileLines)) {
            return false;
        }
        if (this.fileName.matches(".+.sh$")) {
            if (this.removeJavaLibraryPathInShellScript(fileLines)) {
                return true;
            }
        } else if (this.fileName.matches(".+.bat$")) {
            if (this.removeModificationInBatchFile(fileLines)) {
                return true;
            }
        } else {
            return false;
        }
        return this.writeLines(fileLines);
    }

    public static void main(String[] args) {
        int len = args.length;
        if (len < 3) {
            System.err.println("Less number of argument");
            System.exit(-1);
            return;
        }
        String operation = args[0];
        int retVal = -1;
        JwsdpCobundleInstallHelper helper = new JwsdpCobundleInstallHelper(args[1], args[2]);
        try {
            if (operation.equals("--integrate")) {
                retVal = helper.addJavaLibraryPath() ? 0 : -1;
            } else if (operation.equals("--revert")) {
                retVal = helper.removeJavaLibraryPath() ? 0 : -1;
            }
        }
        catch (Exception e) {
            retVal = -1;
            e.printStackTrace();
        }
        System.exit(retVal);
    }
}

