/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Driver;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;

public class ReplicationConnection
implements java.sql.Connection {
    private Connection masterConnection;
    private Connection slavesConnection;
    private Connection currentConnection;

    public ReplicationConnection(Properties masterProperties, Properties slaveProperties) throws SQLException {
        Driver driver = new Driver();
        this.masterConnection = (Connection)driver.connect("jdbc:mysql:///", masterProperties);
        this.slavesConnection = (Connection)driver.connect("jdbc:mysql:///", slaveProperties);
        this.currentConnection = this.masterConnection;
    }

    private synchronized void switchToMasterConnection() throws SQLException {
        String slaveCatalog = this.slavesConnection.getCatalog();
        String masterCatalog = this.masterConnection.getCatalog();
        if (slaveCatalog != null && !slaveCatalog.equals(masterCatalog)) {
            this.masterConnection.setCatalog(slaveCatalog);
        } else if (masterCatalog != null) {
            this.masterConnection.setCatalog(null);
        }
        boolean slavesAutoCommit = this.slavesConnection.getAutoCommit();
        if (this.masterConnection.getAutoCommit() != slavesAutoCommit) {
            this.masterConnection.setAutoCommit(slavesAutoCommit);
        }
        int slavesTransactionIsolation = this.slavesConnection.getTransactionIsolation();
        if (this.masterConnection.getTransactionIsolation() != slavesTransactionIsolation) {
            this.masterConnection.setTransactionIsolation(slavesTransactionIsolation);
        }
        this.currentConnection = this.masterConnection;
    }

    private synchronized void switchToSlavesConnection() throws SQLException {
        String slaveCatalog = this.slavesConnection.getCatalog();
        String masterCatalog = this.masterConnection.getCatalog();
        if (masterCatalog != null && !masterCatalog.equals(slaveCatalog)) {
            this.slavesConnection.setCatalog(masterCatalog);
        } else if (slaveCatalog != null) {
            this.slavesConnection.setCatalog(null);
        }
        boolean masterAutoCommit = this.masterConnection.getAutoCommit();
        if (this.slavesConnection.getAutoCommit() != masterAutoCommit) {
            this.slavesConnection.setAutoCommit(masterAutoCommit);
        }
        int masterTransactionIsolation = this.masterConnection.getTransactionIsolation();
        if (this.slavesConnection.getTransactionIsolation() != masterTransactionIsolation) {
            this.slavesConnection.setTransactionIsolation(masterTransactionIsolation);
        }
        this.currentConnection = this.slavesConnection;
        this.slavesConnection.setAutoCommit(this.masterConnection.getAutoCommit());
        this.slavesConnection.setTransactionIsolation(this.masterConnection.getTransactionIsolation());
    }

    public Statement createStatement() throws SQLException {
        return this.currentConnection.createStatement();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.currentConnection.prepareStatement(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.currentConnection.prepareCall(sql);
    }

    public synchronized String nativeSQL(String sql) throws SQLException {
        return this.currentConnection.nativeSQL(sql);
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.currentConnection.setAutoCommit(autoCommit);
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        return this.currentConnection.getAutoCommit();
    }

    public synchronized void commit() throws SQLException {
        this.currentConnection.commit();
    }

    public synchronized void rollback() throws SQLException {
        this.currentConnection.rollback();
    }

    public synchronized void close() throws SQLException {
        this.masterConnection.close();
        this.slavesConnection.close();
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.currentConnection.isClosed();
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        return this.currentConnection.getMetaData();
    }

    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly) {
            this.switchToSlavesConnection();
        } else {
            this.switchToMasterConnection();
        }
    }

    public synchronized boolean isReadOnly() throws SQLException {
        return this.currentConnection == this.slavesConnection;
    }

    public synchronized void setCatalog(String catalog) throws SQLException {
        this.currentConnection.setCatalog(catalog);
    }

    public synchronized String getCatalog() throws SQLException {
        return this.currentConnection.getCatalog();
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.currentConnection.setTransactionIsolation(level);
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        return this.currentConnection.getTransactionIsolation();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.currentConnection.getWarnings();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.currentConnection.clearWarnings();
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.currentConnection.createStatement(resultSetType, resultSetConcurrency);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.currentConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.currentConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public synchronized Map getTypeMap() throws SQLException {
        return this.currentConnection.getTypeMap();
    }

    public synchronized void setTypeMap(Map arg0) throws SQLException {
        this.currentConnection.setTypeMap(arg0);
    }

    public synchronized void setHoldability(int holdability) throws SQLException {
        this.currentConnection.setHoldability(holdability);
    }

    public synchronized int getHoldability() throws SQLException {
        return this.currentConnection.getHoldability();
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        return this.currentConnection.setSavepoint();
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        return this.currentConnection.setSavepoint(name);
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.currentConnection.rollback(savepoint);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.currentConnection.releaseSavepoint(savepoint);
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.currentConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.currentConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.currentConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.currentConnection.prepareStatement(sql, autoGeneratedKeys);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.currentConnection.prepareStatement(sql, columnIndexes);
    }

    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.currentConnection.prepareStatement(sql, columnNames);
    }

    public synchronized Connection getCurrentConnection() {
        return this.currentConnection;
    }

    public synchronized Connection getSlavesConnection() {
        return this.slavesConnection;
    }

    public synchronized Connection getMasterConnection() {
        return this.masterConnection;
    }
}

