/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ApplicationBean;
import jp.co.argo21.nautica.workflow.dataaccess.ApplicationDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLApplicationDAO
extends AbstractDAO
implements ApplicationDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String APP_NAME = "APP_NAME";
    public static final String APP_TYPE = "APP_TYPE";
    private static final String SQL_SELECT_BY_PRIMARY_KEY = "select * from APPLICATION where APP_NAME = ? ";
    private static final String SQL_INSERT = "insert into APPLICATION (APP_NAME, APP_TYPE) values (?,?)";

    MySQLApplicationDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationBean findByPrimaryKey(String appName) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_PRIMARY_KEY);
        try {
            st.setString(1, appName);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ApplicationBean bean = null;
            if (rs.next()) {
                bean = this.createBean(rs);
            }
            ApplicationBean applicationBean = bean;
            return applicationBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ApplicationBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getAppName());
            st.setInt(2, bean.getAppType());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0049");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private ApplicationBean createBean(ResultSet rs) throws SQLException {
        ApplicationBean bean = new ApplicationBean();
        bean.setAppName(rs.getString(APP_NAME));
        bean.setAppType(rs.getInt(APP_TYPE));
        return bean;
    }
}

