/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DAOException;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessHistoryBean;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessHistoryDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.apache.log4j.Logger;

public class MySQLProcessHistoryDAO
extends AbstractDAO
implements ProcessHistoryDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    public static final String PROC_ID = "PROC_ID";
    public static final String PACKAGE_ID = "PACKAGE_ID";
    public static final String PROC_DEF_ID = "PROC_DEF_ID";
    public static final String PREV_STATE = "PREV_STATE";
    public static final String NEW_STATE = "NEW_STATE";
    public static final String UPDATE_DATE = "UPDATE_DATE";
    public static final String REASON = "REASON";
    private static final String SQL_INSERT = "insert into PROCESSHIST (PROC_ID, PACKAGE_ID, PROC_DEF_ID, PREV_STATE, NEW_STATE, UPDATE_DATE, REASON) values (?,?,?,?,?,?,?)";

    MySQLProcessHistoryDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ProcessHistoryBean bean) throws SQLException, DAOException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_INSERT);
        try {
            st.setString(1, bean.getProcID());
            st.setString(2, bean.getPackageID());
            st.setString(3, bean.getProcDefID());
            st.setInt(4, bean.getPrevState());
            st.setInt(5, bean.getNewState());
            st.setTimestamp(6, bean.getUpdateDate());
            st.setString(7, bean.getReason());
            eLog.debug((Object)st.toString());
            int i = st.executeUpdate();
            if (i != 1) {
                String errMsg = StringManager.get("E0022");
                throw new DAOException(errMsg);
            }
        }
        finally {
            st.close();
        }
    }

    private ProcessHistoryBean createBean(ResultSet rs) throws SQLException {
        ProcessHistoryBean bean = new ProcessHistoryBean();
        bean.setProcID(rs.getString(PROC_ID));
        bean.setPackageID(rs.getString(PACKAGE_ID));
        bean.setProcDefID(rs.getString(PROC_DEF_ID));
        bean.setPrevState(rs.getInt(PREV_STATE));
        bean.setNewState(rs.getInt(NEW_STATE));
        bean.setUpdateDate(rs.getTimestamp(UPDATE_DATE));
        bean.setReason(rs.getString(REASON));
        return bean;
    }
}

