/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.dataaccess.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jp.co.argo21.nautica.workflow.dataaccess.AbstractDAO;
import jp.co.argo21.nautica.workflow.dataaccess.OrganizationBean;
import jp.co.argo21.nautica.workflow.dataaccess.RoleBean;
import jp.co.argo21.nautica.workflow.dataaccess.RoleManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.UserBean;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.MySQLOrganizationManagerDAO;
import jp.co.argo21.nautica.workflow.dataaccess.mysql.MySQLUserManagerDAO;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import org.apache.log4j.Logger;

public class MySQLRoleManagerDAO
extends AbstractDAO
implements RoleManagerDAO {
    protected static Logger eLog = LogManager.getEngineLogger();
    private static final String ROLE_ID = "ROLE_ID";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String SQL_SELECT_BY_ROLE_ID = "select * from ROLE where ROLE_ID = ?";
    private static final String SQL_SELECT_BY_ORG_ID = "select ROLE.* from ROLE, ORGROLEMAP where ORGROLEMAP.ORG_ID = ? and ROLE.ROLE_ID = ORGROLEMAP.ROLE_ID;";
    private static final String SQL_SELECT_BY_USER_ID = "select ROLE.* from ROLE, USERROLEMAP where USERROLEMAP.USER_ID = ? and ROLE.ROLE_ID = USERROLEMAP.ROLE_ID";
    private static final String SQL_SELECT_ORGS_BY_ROLE_ID = "select ORGANIZATION.* from ORGANIZATION, ORGROLEMAP where ORGROLEMAP.ROLE_ID = ? and ORGANIZATION.ORG_ID = ORGROLEMAP.ORG_ID";
    private static final String SQL_SELECT_USERS_BY_ROLE_ID = "select USER.* from USER, USERROLEMAP where USERROLEMAP.ROLE_ID = ? and USER.USER_ID = USERROLEMAP.USER_ID";

    MySQLRoleManagerDAO(Connection conn) {
        super(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleBean findByRoleID(String rid) throws SQLException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_ROLE_ID);
        try {
            st.setString(1, rid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            RoleBean bean = null;
            if (rs.next()) {
                bean = MySQLRoleManagerDAO.createBean(rs);
            }
            RoleBean roleBean = bean;
            return roleBean;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleBean[] findByOrganizationID(String oid) throws SQLException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_ORG_ID);
        try {
            st.setString(1, oid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<RoleBean> beanList = new ArrayList<RoleBean>();
            while (rs.next()) {
                beanList.add(MySQLRoleManagerDAO.createBean(rs));
            }
            RoleBean[] roleBeanArray = beanList.toArray(new RoleBean[beanList.size()]);
            return roleBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleBean[] findByUserID(String uid) throws SQLException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_BY_USER_ID);
        try {
            st.setString(1, uid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<RoleBean> beanList = new ArrayList<RoleBean>();
            while (rs.next()) {
                beanList.add(MySQLRoleManagerDAO.createBean(rs));
            }
            RoleBean[] roleBeanArray = beanList.toArray(new RoleBean[beanList.size()]);
            return roleBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationBean[] findOrganizationsByRoleID(String rid) throws SQLException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_ORGS_BY_ROLE_ID);
        try {
            st.setString(1, rid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<OrganizationBean> beanList = new ArrayList<OrganizationBean>();
            while (rs.next()) {
                beanList.add(MySQLOrganizationManagerDAO.createBean(rs));
            }
            OrganizationBean[] organizationBeanArray = beanList.toArray(new OrganizationBean[beanList.size()]);
            return organizationBeanArray;
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserBean[] findUsersByRoleID(String rid) throws SQLException {
        PreparedStatement st = this.getConnection().prepareStatement(SQL_SELECT_USERS_BY_ROLE_ID);
        try {
            st.setString(1, rid);
            eLog.debug((Object)st.toString());
            ResultSet rs = st.executeQuery();
            ArrayList<UserBean> beanList = new ArrayList<UserBean>();
            while (rs.next()) {
                beanList.add(MySQLUserManagerDAO.createBean(rs));
            }
            UserBean[] userBeanArray = beanList.toArray(new UserBean[beanList.size()]);
            return userBeanArray;
        }
        finally {
            st.close();
        }
    }

    static RoleBean createBean(ResultSet rs) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            columnNames.add(rs.getMetaData().getColumnName(i));
        }
        RoleBean bean = new RoleBean();
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = ((String)columnNames.get(i)).toUpperCase();
            String attribute = (String)rs.getObject(columnName);
            if (columnName.equals(ROLE_ID)) {
                bean.setID(attribute);
            }
            if (columnName.equals(DESCRIPTION)) {
                bean.setName(attribute);
            }
            if (columnName.equals(ROLE_ID) || columnName.equals(DESCRIPTION)) continue;
            bean.setAttribute(columnName, attribute);
        }
        return bean;
    }
}

