/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.definition.impl;

import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.expression.ExceptionExpression;
import jp.co.argo21.nautica.workflow.expression.Expression;
import jp.co.argo21.nautica.workflow.expression.LogicalExpression;
import jp.co.argo21.nautica.workflow.expression.OtherwiseExpression;
import jp.co.argo21.nautica.workflow.expression.RelationalExpression;
import jp.co.argo21.nautica.workflow.expression.UnaryExpression;
import jp.co.argo21.nautica.workflow.util.IDGenerator;
import jp.co.argo21.nautica.workflow.util.StringUtils;
import jp.co.argo21.nautica.workflow.xpdl.ConditionalExpressionDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.wfmc.x2002.xpdl10.ConditionDocument;
import org.wfmc.x2002.xpdl10.TransitionDocument;

public class TransitionDefinitionImpl
implements TransitionDefinition {
    private static final long serialVersionUID = 20050000000000001L;
    private String id;
    private String name;
    private String description;
    private ActivityDefinition source;
    private ActivityDefinition destination;
    private Expression condition;
    private int type;

    public TransitionDefinitionImpl(TransitionDocument.Transition tr, List acts) {
        String id = tr.getId();
        if (StringUtils.checkNull(id)) {
            this.setID(IDGenerator.generate("TR"));
        } else {
            this.setID(id);
        }
        this.setName(tr.getName());
        this.setDescription(tr.getDescription());
        String sid = tr.getFrom();
        this.setSource(this.getActivityDefinition(acts, sid));
        String did = tr.getTo();
        this.setDestination(this.getActivityDefinition(acts, did));
        if (tr.isSetCondition()) {
            ConditionDocument.Condition c = tr.getCondition();
            int type = c.getType().intValue();
            try {
                if (type == 1) {
                    XmlObject obj = XmlObject.Factory.parse((String)c.toString());
                    if (obj == null) {
                        this.setCondition(null);
                    } else if (obj instanceof ConditionalExpressionDocument) {
                        ConditionalExpressionDocument ceDoc = (ConditionalExpressionDocument)obj;
                        ConditionalExpressionDocument.ConditionalExpression ce = ceDoc.getConditionalExpression();
                        if (ce.isSetRelationalExpression()) {
                            this.setCondition(new RelationalExpression(ce.getRelationalExpression()));
                        } else if (ce.isSetUnaryExpression()) {
                            this.setCondition(new UnaryExpression(ce.getUnaryExpression()));
                        } else if (ce.isSetLogicalExpression()) {
                            this.setCondition(new LogicalExpression(ce.getLogicalExpression()));
                        }
                    } else {
                        this.setCondition(null);
                    }
                } else if (type == 2) {
                    this.setCondition(new OtherwiseExpression());
                } else if (type == 3) {
                    this.setCondition(new ExceptionExpression());
                }
            }
            catch (XmlException ex) {}
        } else {
            this.setCondition(null);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public ActivityDefinition getDestination() {
        return this.destination;
    }

    public ActivityDefinition getSource() {
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    private void setID(String id) {
        this.id = id;
    }

    private void setSource(ActivityDefinition act) {
        this.source = act;
    }

    private void setDestination(ActivityDefinition act) {
        this.destination = act;
    }

    private void setDescription(String desc) {
        this.description = desc;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setCondition(Expression cond) {
        this.type = cond == null ? 1 : (cond instanceof OtherwiseExpression ? 2 : (cond instanceof ExceptionExpression ? 3 : 1));
        this.condition = cond;
    }

    private void setType(int i) {
        this.type = i;
    }

    private ActivityDefinition getActivityDefinition(List acts, String id) {
        Iterator it = acts.iterator();
        while (it.hasNext()) {
            ActivityDefinition act = (ActivityDefinition)it.next();
            String aid = act.getID();
            if (!id.equals(aid)) continue;
            return act;
        }
        return null;
    }
}

