/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.PackageDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.impl.DefinitionLoader;
import jp.co.argo21.nautica.workflow.engine.AuditDataRecord;
import jp.co.argo21.nautica.workflow.engine.AuditPrefix;
import jp.co.argo21.nautica.workflow.engine.AuditSuffix;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.DefinitionCache;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.engine.ProcDefImpl;
import jp.co.argo21.nautica.workflow.engine.RepositoryLoader;
import jp.co.argo21.nautica.workflow.engine.SessionManagerFactory;
import jp.co.argo21.nautica.workflow.engine.SystemChecker;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.rmi.RepositoryLoaderPO;
import jp.co.argo21.nautica.workflow.security.SessionManager;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.DefinitionRepository;
import jp.co.argo21.nautica.workflow.wfmc.Filter;
import jp.co.argo21.nautica.workflow.wfmc.InvalidFilterException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidProcessDefinitionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.InvalidStateException;
import jp.co.argo21.nautica.workflow.wfmc.ProcDef;
import jp.co.argo21.nautica.workflow.wfmc.ProcessDefinitionState;
import jp.co.argo21.nautica.workflow.wfmc.TransitionNotAllowedException;
import org.apache.log4j.Logger;

public class DefinitionRepositoryImpl
implements DefinitionRepository,
RepositoryLoader {
    private static final String REPOSITORY_DIR = "repository";
    private static final String WORKFLOW_REPOSITORY_LOADER = "RepositoryLoader";
    private static Logger eLog = LogManager.getEngineLogger();
    private static Logger audit = LogManager.getAuditLogger();
    private DefinitionLoader loader = new DefinitionLoader(DefinitionRepositoryImpl.getRepositoryPath());
    private DefinitionCache cache = new DefinitionCache();

    private static String getRepositoryPath() throws WorkflowException {
        String home = System.getProperty("nautica.home");
        String separator = System.getProperty("file.separator");
        String path = home + separator + REPOSITORY_DIR;
        File confFile = new File(path);
        if (!confFile.exists()) {
            String msg = StringManager.get("E0052") + "(path=" + path + ")";
            eLog.error((Object)msg);
            throw new WorkflowException(msg);
        }
        if (!confFile.isDirectory()) {
            String msg = StringManager.get("E0053") + "(path=" + path + ")";
            eLog.error((Object)msg);
            throw new WorkflowException(msg);
        }
        return path;
    }

    DefinitionRepositoryImpl() throws WorkflowException {
        try {
            String scope = System.getProperty("nautica.workflow.scope");
            if (scope == null) {
                scope = "";
            }
            scope = scope.trim();
            InitialContext context = new InitialContext();
            try {
                context.createSubcontext(scope);
            }
            catch (NameAlreadyBoundException ex) {
                // empty catch block
            }
            if (!scope.equals("")) {
                scope = scope + "/";
            }
            RepositoryLoaderPO rlPO = new RepositoryLoaderPO(this);
            context.rebind(scope + WORKFLOW_REPOSITORY_LOADER, (Object)rlPO);
            eLog.info((Object)(StringManager.get("I0045") + "(" + scope + WORKFLOW_REPOSITORY_LOADER + ")"));
        }
        catch (Exception e) {
            String errMsg = StringManager.get("E0072");
            eLog.error((Object)errMsg);
            throw new WorkflowException(errMsg, e);
        }
    }

    public void registerDefinition(String session, String pdid, String path) throws InvalidSessionException, WorkflowException {
        String argInfo = "(NAUTICA API = registerDefinition,session = [" + session + "]," + "pdid = [" + pdid + "]," + "path = [" + path + "])";
        PackageDefinition packageDefinition = null;
        try {
            DataAccessManager.begin(false);
            this.validateSession(session);
            if (pdid == null || pdid.trim().equals("")) {
                String E0105 = StringManager.get("E0105");
                throw new WorkflowException(E0105);
            }
            if (path == null || path.trim().equals("")) {
                String E0106 = StringManager.get("E0106");
                throw new WorkflowException(E0106);
            }
            packageDefinition = this.loader.load(path);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            DefinitionDAO dao = daoFactory.getDefinitionDAO();
            Iterator it = packageDefinition.getProcesses().iterator();
            int i = 0;
            while (it.hasNext()) {
                ProcessDefinition def = (ProcessDefinition)it.next();
                String ipdid = def.getID();
                DefinitionBean bean = new DefinitionBean();
                bean.setProcessDefinitionID(pdid + "-" + i);
                bean.setPath(path);
                bean.setInternalPDID(ipdid);
                bean.setRegisterDate(new Timestamp(System.currentTimeMillis()));
                bean.setState(ProcessDefinitionState.ENABLE.toInt());
                dao.insert(bean);
                ++i;
            }
            DataAccessManager.commit();
        }
        catch (InvalidSessionException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (WorkflowException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0107 = StringManager.get("E0107") + argInfo;
            eLog.error((Object)E0107, (Throwable)ex);
            throw new WorkflowException(E0107, ex);
        }
    }

    public ProcDef[] getProcessDefinitions(String session, Filter filter) throws InvalidSessionException, InvalidFilterException {
        String argInfo = "(WfMC API = getProcessDefinitions,session = [" + session + "]," + "filter = [" + filter + "])";
        try {
            DataAccessManager.begin(false);
            this.validateSession(session);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            DefinitionDAO dao = daoFactory.getDefinitionDAO();
            List list = dao.findByFilter(filter);
            ArrayList<ProcDefImpl> procDefs = new ArrayList<ProcDefImpl>();
            Iterator it = list.iterator();
            int i = 0;
            while (it.hasNext()) {
                DefinitionBean bean = (DefinitionBean)it.next();
                ProcessDefinition def = this.cache.getProcessDefinition(bean.getProcessDefinitionID());
                ProcDefImpl impl = new ProcDefImpl();
                impl.setID(bean.getProcessDefinitionID());
                impl.setName(def.getName());
                impl.setDescription(def.getDescription());
                impl.setState(ProcessDefinitionState.getState(bean.getState()));
                procDefs.add(impl);
                ++i;
            }
            DataAccessManager.commit();
            return procDefs.toArray(new ProcDef[procDefs.size()]);
        }
        catch (InvalidSessionException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (InvalidFilterException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (WorkflowException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0108 = StringManager.get("E0108") + argInfo;
            eLog.error((Object)E0108, (Throwable)ex);
            throw new InvalidFilterException(E0108, ex);
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0108 = StringManager.get("E0108") + argInfo;
            eLog.error((Object)E0108, (Throwable)ex);
            throw new InvalidFilterException(E0108, ex);
        }
    }

    public ProcessDefinitionState[] getProcessDefinitionStates(String session, String pdid) throws InvalidSessionException, InvalidProcessDefinitionException {
        String argInfo = "(WfMC API = getProcessDefinitionStates,session = [" + session + "]," + "pdid = [" + pdid + "])";
        Object packageDefinition = null;
        try {
            DataAccessManager.begin(false);
            this.validateSession(session);
            this.checkProcessDefinitionID(pdid);
            DefinitionBean bean = this.cache.getDefinitionBean(pdid);
            ProcessDefinitionState[] states = new ProcessDefinitionState[1];
            ProcessDefinitionState currentState = ProcessDefinitionState.getState(bean.getState());
            states[0] = ProcessDefinitionState.ENABLE.equals(currentState) ? ProcessDefinitionState.DISABLE : ProcessDefinitionState.ENABLE;
            DataAccessManager.commit();
            return states;
        }
        catch (InvalidSessionException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (InvalidProcessDefinitionException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (WorkflowException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0109 = StringManager.get("E0109") + argInfo;
            eLog.error((Object)E0109, (Throwable)ex);
            throw new InvalidProcessDefinitionException(E0109, ex);
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0109 = StringManager.get("E0109") + argInfo;
            eLog.error((Object)E0109, (Throwable)ex);
            throw new InvalidProcessDefinitionException(E0109, ex);
        }
    }

    public void changeProcessDefinitionState(String session, String pdid, ProcessDefinitionState state) throws InvalidSessionException, InvalidProcessDefinitionException, InvalidStateException, TransitionNotAllowedException {
        String argInfo = "(WfMC API = changeProcessDefinitionState,session = [" + session + "]," + "pdid = [" + pdid + "]," + "state = [" + state.toString() + "])";
        try {
            DataAccessManager.begin(false);
            this.validateSession(session);
            this.checkProcessDefinitionID(pdid);
            if (state == null) {
                String E0110 = StringManager.get("E0110");
                throw new InvalidStateException(E0110);
            }
            this.setProcessDefinitionState(pdid, state);
            DataAccessManager.commit();
            AuditDataRecord data = new AuditDataRecord(new AuditPrefix("", "WMChangedProcessDifinitionState", session), new AuditSuffix());
            data.setDataElement("ProcessDefinitionID", pdid);
            data.setDataElement("NewProcessDefinitionState", state);
            audit.info((Object)data);
        }
        catch (InvalidSessionException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (InvalidProcessDefinitionException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (InvalidStateException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (TransitionNotAllowedException ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String msg = ex.getMessage() + argInfo;
            eLog.error((Object)msg, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            try {
                DataAccessManager.rollback();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            String E0186 = StringManager.get("E0186") + argInfo;
            eLog.error((Object)E0186, (Throwable)ex);
            throw new TransitionNotAllowedException(E0186, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getDefinition(String session, String adminKey, String path) {
        String string;
        BufferedReader br;
        String argInfo;
        block12: {
            argInfo = "(NAUTICA API = getDefinition,session = [" + session + "]," + "adminKey = [" + adminKey + "]," + "path = [" + path + "])";
            String separator = System.getProperty("file.separator");
            String filepath = System.getProperty("nautica.home") + separator + REPOSITORY_DIR + separator + path;
            br = null;
            this.validateSession(session);
            SystemChecker.checkAdmin(adminKey);
            String lineseparator = System.getProperty("line.separator");
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filepath), "utf-8"));
            StringBuffer definition = new StringBuffer();
            while (br.ready()) {
                definition.append(br.readLine());
                definition.append(lineseparator);
            }
            string = definition.toString();
            Object var12_17 = null;
            if (br == null) break block12;
            try {
                br.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return string;
        catch (WorkflowException ex) {
            String string2;
            block13: {
                String W0000 = ex.getMessage() + argInfo;
                eLog.warn((Object)W0000, (Throwable)ex);
                string2 = null;
                Object var12_18 = null;
                if (br == null) break block13;
                try {
                    br.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return string2;
        }
        catch (IOException ex) {
            String string3;
            block14: {
                String W0003 = StringManager.get("W0003") + argInfo;
                eLog.warn((Object)W0003, (Throwable)ex);
                string3 = null;
                Object var12_19 = null;
                if (br == null) break block14;
                {
                    catch (Throwable throwable) {
                        block15: {
                            Object var12_20 = null;
                            if (br == null) break block15;
                            try {
                                br.close();
                            }
                            catch (IOException e) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    br.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return string3;
        }
    }

    public String getDefinitionPath(String session, String pdname) {
        String argInfo = "(NAUTICA API = getDefinitionPath,session = [" + session + "]," + "pdname = [" + pdname + "])";
        try {
            this.validateSession(session);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            DefinitionDAO defDAO = daoFactory.getDefinitionDAO();
            DefinitionBean defbean = defDAO.findByPrimaryKey(pdname);
            if (defbean != null) {
                return defbean.getPath();
            }
            return null;
        }
        catch (WorkflowException ex) {
            String W0000 = ex.getMessage() + argInfo;
            eLog.warn((Object)W0000, (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            String W0004 = StringManager.get("W0004") + argInfo;
            eLog.warn((Object)W0004, (Throwable)ex);
            return null;
        }
    }

    public void unbind() throws NamingException {
        String scope = System.getProperty("nautica.workflow.scope");
        if (scope == null) {
            scope = "";
        }
        scope = scope.trim();
        InitialContext context = new InitialContext();
        if (!scope.equals("")) {
            scope = scope + "/";
        }
        context.unbind(scope + WORKFLOW_REPOSITORY_LOADER);
        eLog.info((Object)StringManager.get("I0046"));
    }

    PackageDefinition getPackageDefinition(String pdid) throws WorkflowException {
        return this.cache.getPackageDefinition(pdid);
    }

    ProcessDefinition getProcessDefinition(String pdid) throws WorkflowException {
        return this.cache.getProcessDefinition(pdid);
    }

    ProcessDefinitionState getProcessDefinitionState(String pdid) throws WorkflowException {
        try {
            DefinitionBean bean = this.cache.getDefinitionBean(pdid);
            int stateNum = bean.getState();
            return ProcessDefinitionState.getState(stateNum);
        }
        catch (Exception ex) {
            String E0187 = StringManager.get("E0187");
            throw new WorkflowException(E0187, ex);
        }
    }

    void setProcessDefinitionState(String pdid, ProcessDefinitionState state) throws InvalidProcessDefinitionException, InvalidStateException, TransitionNotAllowedException {
        try {
            ProcessDefinitionState currentState = this.getProcessDefinitionState(pdid);
            ProcessDefinitionState.checkTransition(currentState, state);
            WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
            DefinitionDAO dao = daoFactory.getDefinitionDAO();
            dao.updateState(pdid, currentState.toInt(), state.toInt());
        }
        catch (InvalidProcessDefinitionException ex) {
            throw ex;
        }
        catch (InvalidStateException ex) {
            throw ex;
        }
        catch (TransitionNotAllowedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String E0186 = StringManager.get("E0186");
            throw new TransitionNotAllowedException(E0186, ex);
        }
    }

    private void checkProcessDefinitionID(String pdid) throws InvalidProcessDefinitionException {
        if (pdid == null || pdid.trim().equals("")) {
            String E0188 = StringManager.get("E0188");
            throw new InvalidProcessDefinitionException(E0188);
        }
    }

    private void validateSession(String session) throws InvalidSessionException {
        if (session == null || session.trim().equals("")) {
            String E0170 = StringManager.get("E0170");
            throw new InvalidSessionException(E0170);
        }
        SessionManagerFactory factory = SessionManagerFactory.getInstance();
        SessionManager manager = factory.getSessionManager();
        manager.validateSession(session);
    }
}

