/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityBean;
import jp.co.argo21.nautica.workflow.dataaccess.ActivityDAO;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionBean;
import jp.co.argo21.nautica.workflow.dataaccess.DefinitionDAO;
import jp.co.argo21.nautica.workflow.dataaccess.ProcessBean;
import jp.co.argo21.nautica.workflow.dataaccess.VariableDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemBean;
import jp.co.argo21.nautica.workflow.dataaccess.WorkItemDAO;
import jp.co.argo21.nautica.workflow.dataaccess.WorkflowDAOFactory;
import jp.co.argo21.nautica.workflow.definition.ActivityDefinition;
import jp.co.argo21.nautica.workflow.definition.ParticipantDefinition;
import jp.co.argo21.nautica.workflow.definition.ProcessDefinition;
import jp.co.argo21.nautica.workflow.definition.TransitionDefinition;
import jp.co.argo21.nautica.workflow.engine.AbstractActivityBehavior;
import jp.co.argo21.nautica.workflow.engine.ActivityInternal;
import jp.co.argo21.nautica.workflow.engine.ConditionEvaluator;
import jp.co.argo21.nautica.workflow.engine.DataAccessManager;
import jp.co.argo21.nautica.workflow.engine.ProcessInternal;
import jp.co.argo21.nautica.workflow.engine.StartActivityRequestMessage;
import jp.co.argo21.nautica.workflow.engine.SystemMessageTransporter;
import jp.co.argo21.nautica.workflow.engine.WorkflowEngine;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.util.UniqueKeyGenerator;
import jp.co.argo21.nautica.workflow.wfmc.ActivityState;

public class InteractiveActivityBehavior
extends AbstractActivityBehavior {
    public void abort(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act, boolean checkChild) throws Exception {
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        String aid = abean.getActivityID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        WorkItemDAO wiDAO = daoFactory.getWorkItemDAO();
        wiDAO.deleteByProcessIDANDActivityID(pid, aid);
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.CLOSED_ABORTED, ts);
    }

    public void start(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act) throws Exception {
        ProcessBean pbean = proc.getBean();
        String pdid = pbean.getProcDefinitionID();
        ActivityBean abean = act.getBean();
        String pid = abean.getProcessID();
        String aid = abean.getActivityID();
        String performerID = ad.getPerformerID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        DefinitionDAO defDAO = daoFactory.getDefinitionDAO();
        DefinitionBean defbean = defDAO.findByPrimaryKey(pdid);
        String defID = defbean.getProcessDefinitionID();
        ParticipantDefinition partd = this.getParticipantDefinition(defID, performerID);
        if (partd == null) {
            act.terminate();
            String msg = StringManager.get("F0002");
            eLog.fatal((Object)msg);
            throw new WorkflowException(msg);
        }
        WorkItemBean wbean = new WorkItemBean();
        wbean.setID(UniqueKeyGenerator.generate("WII"));
        wbean.setProcessID(pid);
        wbean.setActivityID(aid);
        wbean.setParticipantName(partd.getName());
        wbean.setParticipantType(partd.getType());
        WorkItemDAO workDAO = daoFactory.getWorkItemDAO();
        workDAO.insert(wbean);
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.OPEN_RUNNING, ts);
    }

    public void terminate(ProcessDefinition pd, ActivityDefinition ad, ProcessInternal proc, ActivityInternal act, boolean checkChild) throws Exception {
        ProcessBean pbean = proc.getBean();
        String pid = pbean.getID();
        ActivityBean abean = act.getBean();
        String aid = abean.getActivityID();
        String bid = abean.getBlockID();
        WorkflowDAOFactory daoFactory = DataAccessManager.getDAOFactory();
        WorkItemDAO wiDAO = daoFactory.getWorkItemDAO();
        wiDAO.deleteByProcessIDANDActivityID(pid, aid);
        ArrayList<ActivityBean> acts = new ArrayList<ActivityBean>();
        VariableDAO varDAO = daoFactory.getVariableDAO();
        List vars = varDAO.findByProcessIDAsList(pid);
        List trs = ConditionEvaluator.evaluate(pd, ad, vars, true);
        Iterator it = trs.iterator();
        while (it.hasNext()) {
            TransitionDefinition tr = (TransitionDefinition)it.next();
            ActivityDefinition dest = tr.getDestination();
            ActivityBean ab = this.createActivity(pd, dest, pbean, bid);
            acts.add(ab);
        }
        if (acts.size() == 0) {
            this.suspend(pd, ad, proc, act);
            String msg = StringManager.get("F0001");
            eLog.fatal((Object)msg);
            return;
        }
        ActivityDAO actDAO = daoFactory.getActivityDAO();
        Timestamp ts = DataAccessManager.getAccessTime();
        actDAO.updateState(act.getBean(), ActivityState.CLOSED_TERMINATED, ts);
        Iterator ait = acts.iterator();
        while (ait.hasNext()) {
            ActivityBean ab = (ActivityBean)ait.next();
            WorkflowEngine engine = WorkflowEngine.getInstance();
            String abid = ab.getActivityID();
            StartActivityRequestMessage sarmsg = new StartActivityRequestMessage(pid, abid);
            SystemMessageTransporter mt = new SystemMessageTransporter("START_ACTIVITY_REQUEST");
            mt.sendMessage(sarmsg);
        }
    }
}

