/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LogManager {
    private static final String ENGINE_LOGGER = "Engine";
    private static final String AUDIT_LOGGER = "EventAudit";
    private static final String SECURITY_LOGGER = "Security";
    private static boolean initialized = false;

    static void create() throws WorkflowException {
        if (initialized) {
            throw new WorkflowException("Logging already initialized.");
        }
        String path = LogManager.getConfigPath();
        try {
            PropertyConfigurator.configure((String)path);
        }
        catch (Exception ex) {
            throw new WorkflowException("Logging configuration failed.", ex);
        }
        initialized = true;
    }

    private static String getConfigPath() throws WorkflowException {
        String home = System.getProperty("nautica.home");
        String conf = System.getProperty("nautica.workflow.logging.config");
        String separator = System.getProperty("file.separator");
        String path = home + separator + "config" + separator + conf;
        File confFile = new File(path);
        if (!confFile.exists()) {
            throw new WorkflowException(path + " is not found.");
        }
        if (!confFile.isFile()) {
            throw new WorkflowException(path + " is not file.");
        }
        return path;
    }

    public static Logger getEngineLogger() {
        return Logger.getLogger((String)ENGINE_LOGGER);
    }

    public static Logger getAuditLogger() {
        return Logger.getLogger((String)AUDIT_LOGGER);
    }

    public static Logger getSercurityLogger() {
        return Logger.getLogger((String)SECURITY_LOGGER);
    }
}

