/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.QueueConnectionFactory;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.jms.WorkflowMQ;
import jp.co.argo21.nautica.workflow.jms.WorkflowMessageAdapter;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;
import jp.co.argo21.nautica.workflow.util.StringManager;
import org.activemq.ActiveMQConnectionFactory;
import org.apache.log4j.Logger;

class MessageBroker {
    private static Logger eLog = LogManager.getEngineLogger();
    private static MessageBroker broker;
    private ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
    private Map queues;

    static void create() throws WorkflowException {
        if (broker != null) {
            String msg = StringManager.get("E0054");
            eLog.error((Object)msg);
            throw new WorkflowException(msg);
        }
        String[] args = new String[1];
        String path = MessageBroker.getConfigPath();
        try {
            broker = new MessageBroker(path);
        }
        catch (Exception ex) {
            String msg = StringManager.get("E0055");
            eLog.error((Object)msg, (Throwable)ex);
            throw new WorkflowException(msg, ex);
        }
    }

    private static String getConfigPath() throws WorkflowException {
        String home = System.getProperty("nautica.home");
        String conf = System.getProperty("nautica.workflow.mq.config");
        String separator = System.getProperty("file.separator");
        String path = home + separator + "config" + separator + conf;
        File confFile = new File(path);
        if (!confFile.exists()) {
            String msg = StringManager.get("E0057") + "(ConfigPath=" + path + ")";
            eLog.error((Object)msg);
            throw new WorkflowException(msg);
        }
        if (!confFile.isFile()) {
            String msg = StringManager.get("E0058") + "(ConfigPath=" + path + ")";
            eLog.error((Object)msg);
            throw new WorkflowException(msg);
        }
        try {
            return confFile.toURL().toString();
        }
        catch (Exception ex) {
            String msg = StringManager.get("E0059") + "(ConfigPath=" + path + ")";
            eLog.error((Object)msg, (Throwable)ex);
            throw new WorkflowException(msg, ex);
        }
    }

    static MessageBroker getInstance() {
        return broker;
    }

    private MessageBroker(String path) {
        this.factory.setBrokerXmlConfig(path);
        this.queues = new Hashtable();
    }

    void generateQueue(String queueName, WorkflowMessageAdapter adapter) throws WorkflowException {
        if (this.queues.containsKey(queueName)) {
            String msg = StringManager.get("E0056");
            eLog.error((Object)msg);
            throw new WorkflowException(msg);
        }
        WorkflowMQ queue = new WorkflowMQ((QueueConnectionFactory)this.factory, queueName, adapter);
        this.queues.put(queueName, queue);
        queue.start();
    }

    void shutdown() {
        Iterator it = this.queues.values().iterator();
        while (it.hasNext()) {
            WorkflowMQ queue = (WorkflowMQ)it.next();
            queue.shutdown();
        }
    }

    public WorkflowMQ getWorkflowMQ(String queueName) {
        return (WorkflowMQ)this.queues.get(queueName);
    }
}

