/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

class SystemChecker {
    private static final String PROP_NAME = "nautica.properties";

    SystemChecker() {
    }

    static void checkBootPath() throws WorkflowException {
        String home = System.getProperty("nautica.home");
        SystemChecker.checkHome(home);
        SystemChecker.checkDir(home, "lib", "Library path");
        SystemChecker.checkDir(home, "config", "Configuration path");
        SystemChecker.checkDir(home, "repository", "Repository path");
        SystemChecker.checkDir(home, "logs", "Logging path");
        SystemChecker.checkDir(home, "temp", "Temporary path");
        SystemChecker.checkConfig(home);
        SystemChecker.checkProperties();
    }

    static void checkAdmin(String adminkey) throws WorkflowException {
        String admin = System.getProperty("nautica.workflow.admin");
        if (adminkey == null) {
            throw new WorkflowException("Administrator key is not set.");
        }
        if (!adminkey.equals(admin)) {
            throw new WorkflowException("Administrator key is not valid.");
        }
    }

    static void checkProperties() throws WorkflowException {
        SystemChecker.checkProperty("nautica.workflow.admin");
        SystemChecker.checkProperty("java.home");
    }

    private static void checkHome(String home) throws WorkflowException {
        if (home == null || home.trim().equals("")) {
            throw new WorkflowException("nautica.home is not set.");
        }
        File dir = new File(home);
        if (!dir.exists()) {
            throw new WorkflowException("nautica.home is invalid path.: " + home);
        }
        if (!dir.isDirectory()) {
            throw new WorkflowException("nautica.home is not directory.: " + home);
        }
    }

    private static void checkDir(String home, String name, String label) throws WorkflowException {
        String separator = System.getProperty("file.separator");
        String dirPath = home + separator + name;
        File dir = new File(dirPath);
        if (!dir.exists()) {
            throw new WorkflowException(label + " is not found.");
        }
        if (!dir.isDirectory()) {
            throw new WorkflowException(label + " is not directory.");
        }
    }

    private static void checkConfig(String home) throws WorkflowException {
        String separator = System.getProperty("file.separator");
        String confDirPath = home + separator + "config";
        String propFilePath = confDirPath + separator + PROP_NAME;
        File propFile = new File(propFilePath);
        if (!propFile.exists()) {
            throw new WorkflowException("nautica.properties is not found.");
        }
        if (!propFile.isFile()) {
            throw new WorkflowException("nautica.properties is not file.");
        }
        try {
            FileInputStream is = new FileInputStream(propFile);
            Properties prop = new Properties();
            prop.load(is);
            ((InputStream)is).close();
            Properties sysprop = System.getProperties();
            sysprop.putAll((Map<?, ?>)prop);
        }
        catch (IOException ex) {
            throw new WorkflowException("nautica.properties cannot loaded.", ex);
        }
    }

    private static void checkProperty(String name) throws WorkflowException {
        String value = System.getProperty(name);
        if (value == null || value.trim().equals("")) {
            throw new WorkflowException(value + "property is not set.");
        }
    }
}

