/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import jp.co.argo21.nautica.workflow.engine.LogManager;
import jp.co.argo21.nautica.workflow.ta.config.Agent;
import jp.co.argo21.nautica.workflow.ta.config.App;
import jp.co.argo21.nautica.workflow.ta.config.ToolAgentsDocument;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidApplicationException;
import jp.co.argo21.nautica.workflow.wfmc.ToolAgent;
import jp.co.argo21.nautica.workflow.wfmc.ToolAgentFactory;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;

public class ToolAgentManager {
    private static Logger eLog = LogManager.getEngineLogger();
    private static ToolAgentManager singleton;
    private static final String CONFIG = "toolagent.xml";
    private Map applications = new Hashtable();

    static void create() throws Exception {
        singleton = new ToolAgentManager();
        try {
            singleton.init();
        }
        catch (Exception ex) {
            eLog.error((Object)StringManager.get("E1005"));
            throw ex;
        }
    }

    static ToolAgentManager getInstance() {
        return singleton;
    }

    private ToolAgentManager() {
    }

    private void init() throws Exception {
        String home = System.getProperty("nautica.home");
        String separator = System.getProperty("file.separator");
        String path = home + separator + "config" + separator + CONFIG;
        File confFile = new File(path);
        FileInputStream in = new FileInputStream(confFile);
        XmlOptions opts = new XmlOptions();
        opts.setCharacterEncoding("utf-8");
        ToolAgentsDocument doc = ToolAgentsDocument.Factory.parse((InputStream)in, (XmlOptions)opts);
        ((InputStream)in).close();
        this.load(doc);
    }

    ToolAgent getToolAgent(String appName) throws InvalidApplicationException {
        if (appName == null) {
            String E0147 = StringManager.get("E0147");
            eLog.fatal((Object)E0147);
            throw new InvalidApplicationException(E0147);
        }
        ToolAgentFactory factory = (ToolAgentFactory)this.applications.get(appName);
        if (factory == null) {
            String E0148 = StringManager.get("E0148") + "(ApplicationName = " + appName + ")";
            eLog.fatal((Object)E0148);
            throw new InvalidApplicationException(E0148);
        }
        return factory.getToolAgent();
    }

    private void load(ToolAgentsDocument doc) throws Exception {
        ToolAgentsDocument.ToolAgents config = doc.getToolAgents();
        Agent[] agents = config.getAgentArray();
        for (int i = 0; i < agents.length; ++i) {
            String cn = agents[i].getClassname();
            int retry = 1;
            if (agents[i].isSetRetry()) {
                retry = agents[i].getRetry().intValue();
            }
            ToolAgentFactory factory = (ToolAgentFactory)Class.forName(cn).newInstance();
            factory.setRetryCount(retry);
            App[] apps = agents[i].getAppArray();
            for (int j = 0; j < apps.length; ++j) {
                this.applications.put(apps[j].getName(), factory);
            }
        }
    }
}

