/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nautica.workflow.expression;

import java.util.List;
import jp.co.argo21.nautica.workflow.expression.Expression;
import jp.co.argo21.nautica.workflow.expression.RelationalExpression;
import jp.co.argo21.nautica.workflow.expression.UnaryExpression;
import jp.co.argo21.nautica.workflow.xpdl.LogicalExpressionDocument;
import jp.co.argo21.nautica.workflow.xpdl.RelationalExpressionDocument;
import jp.co.argo21.nautica.workflow.xpdl.UnaryExpressionDocument;
import org.apache.xmlbeans.XmlObject;

public class LogicalExpression
implements Expression {
    private static final long serialVersionUID = 20050000000000001L;
    public static final int AND = 2;
    public static final int OR = 1;
    private static final String AND_STR = "&&";
    private static final String OR_STR = "||";
    private int operator;
    private Expression[] subExpressions;

    public LogicalExpression(Expression expL, int ope, Expression expR) {
        this.operator = ope;
        this.subExpressions = new Expression[2];
        this.subExpressions[0] = expL;
        this.subExpressions[1] = expR;
    }

    public LogicalExpression(LogicalExpressionDocument.LogicalExpression exp) {
        int j;
        this.operator = exp.getType().intValue();
        this.subExpressions = new Expression[2];
        int i = 0;
        for (j = 0; j < exp.sizeOfUnaryExpressionArray() && i != 2; ++i, ++j) {
            UnaryExpressionDocument.UnaryExpression unary = exp.getUnaryExpressionArray(j);
            this.subExpressions[i] = new UnaryExpression(unary);
        }
        for (j = 0; j < exp.sizeOfLogicalExpressionArray() && i != 2; ++i, ++j) {
            LogicalExpressionDocument.LogicalExpression logic = exp.getLogicalExpressionArray(j);
            this.subExpressions[i] = new LogicalExpression(logic);
        }
        for (j = 0; j < exp.sizeOfRelationalExpressionArray() && i != 2; ++i, ++j) {
            RelationalExpressionDocument.RelationalExpression rel = exp.getRelationalExpressionArray(j);
            this.subExpressions[i] = new RelationalExpression(rel);
        }
    }

    public void saveTo(XmlObject o) {
        if (o == null) {
            return;
        }
        if (!(o instanceof LogicalExpressionDocument.LogicalExpression)) {
            return;
        }
        LogicalExpressionDocument.LogicalExpression le = (LogicalExpressionDocument.LogicalExpression)o;
        le.setType(LogicalExpressionDocument.LogicalExpression.Type.Enum.forInt((int)this.operator));
        for (int i = 0; i < this.subExpressions.length; ++i) {
            if (this.subExpressions[i] == null) continue;
            UnaryExpressionDocument.UnaryExpression exp = null;
            if (this.subExpressions[i] instanceof UnaryExpression) {
                exp = le.addNewUnaryExpression();
            } else if (this.subExpressions[i] instanceof LogicalExpression) {
                exp = le.addNewLogicalExpression();
            } else if (this.subExpressions[i] instanceof RelationalExpression) {
                exp = le.addNewRelationalExpression();
            }
            this.subExpressions[i].saveTo((XmlObject)exp);
        }
    }

    public boolean eval(List list) {
        boolean left = false;
        boolean right = false;
        if (this.subExpressions[0] != null) {
            left = this.subExpressions[0].eval(list);
        }
        if (this.subExpressions[1] != null) {
            right = this.subExpressions[1].eval(list);
        }
        if (this.operator == 2) {
            return left && right;
        }
        return left || right;
    }

    public String getExpressionString() {
        String ls = "null";
        String rs = "null";
        if (this.subExpressions[0] != null) {
            ls = this.subExpressions[0].getExpressionString();
        }
        if (this.subExpressions[1] != null) {
            rs = this.subExpressions[1].getExpressionString();
        }
        return "(" + ls + ") " + this.getOpeString() + " (" + rs + ")";
    }

    public String getExpressionString(List vars) {
        String ls = "null";
        String rs = "null";
        if (this.subExpressions[0] != null) {
            ls = this.subExpressions[0].getExpressionString(vars);
        }
        if (this.subExpressions[1] != null) {
            rs = this.subExpressions[1].getExpressionString(vars);
        }
        return "(" + ls + ") " + this.getOpeString() + " (" + rs + ")";
    }

    public void getAllExpressions(List exps) {
        if (!exps.contains(this)) {
            exps.add(this);
        }
        if (this.subExpressions[0] != null) {
            this.subExpressions[0].getAllExpressions(exps);
        }
        if (this.subExpressions[1] != null) {
            this.subExpressions[1].getAllExpressions(exps);
        }
    }

    private String getOpeString() {
        if (this.operator == 2) {
            return AND_STR;
        }
        return OR_STR;
    }
}

